/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world;

import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.data.config.entry.WorldGenEntry;
import hellfirepvp.astralsorcery.common.data.world.WorldCacheManager;
import hellfirepvp.astralsorcery.common.data.world.data.StructureGenBuffer;
import hellfirepvp.astralsorcery.common.util.struct.StructureBlockArray;
import hellfirepvp.astralsorcery.common.world.WorldGenAttribute;
import hellfirepvp.astralsorcery.common.world.structure.WorldGenAttributeStructure;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.config.Configuration;

public abstract class WorldGenAttributeCommon
extends WorldGenAttribute {
    protected final WorldGenEntry cfgEntry;
    private final boolean onlyGenerateInSkyDimensions;

    public WorldGenAttributeCommon(int attributeVersion, boolean onlyGenerateInSkyDimensions, String entry, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        this(attributeVersion, 140, onlyGenerateInSkyDimensions, entry, ignoreBiomeSpecifications, types);
    }

    public WorldGenAttributeCommon(int attributeVersion, int defaultChance, boolean onlyGenerateInSkyDimensions, String entry, boolean ignoreBiomeSpecifications, BiomeDictionary.Type ... types) {
        super(attributeVersion);
        this.onlyGenerateInSkyDimensions = onlyGenerateInSkyDimensions;
        this.cfgEntry = new WorldGenEntry(entry, defaultChance, ignoreBiomeSpecifications, types){

            @Override
            public void loadFromConfig(Configuration cfg) {
                super.loadFromConfig(cfg);
                WorldGenAttributeCommon.this.loadAdditionalConfigEntries(cfg);
            }
        };
        Config.addDynamicEntry(this.cfgEntry);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world) {
        BlockPos pos;
        if (this.canGenerateAtAll(chunkX, chunkZ, world, random) && (pos = this.getGenerationPosition(chunkX, chunkZ, world, random)) != null) {
            this.tryGenerateAtPosition(pos, world, random);
        }
    }

    public void tryGenerateAtPosition(BlockPos pos, World world, Random random) {
        if (this.fulfillsSpecificConditions(pos, world, random)) {
            this.generate(pos, world, random);
        }
    }

    protected void loadAdditionalConfigEntries(Configuration cfg) {
    }

    public abstract void generate(BlockPos var1, World var2, Random var3);

    public abstract boolean fulfillsSpecificConditions(BlockPos var1, World var2, Random var3);

    @Nullable
    public abstract BlockPos getGenerationPosition(int var1, int var2, World var3, Random var4);

    public boolean canGenerateAtAll(int chX, int chZ, World world, Random rand) {
        if (!this.cfgEntry.shouldGenerate()) {
            return false;
        }
        if (this.onlyGenerateInSkyDimensions && !Config.worldGenDimWhitelist.contains(world.field_73011_w.getDimension())) {
            return false;
        }
        double chanceMultiplier = 1.0;
        if (Config.respectIdealDistances && this instanceof WorldGenAttributeStructure) {
            BlockPos pos;
            StructureGenBuffer.StructureType type = ((WorldGenAttributeStructure)this).getStructureType();
            StructureGenBuffer buf = (StructureGenBuffer)WorldCacheManager.getOrLoadData(world, WorldCacheManager.SaveKey.STRUCTURE_GEN);
            double dst = buf.getDstToClosest(type, new BlockPos((pos = new BlockPos(chX * 16, 0, chZ * 16)).func_177958_n(), world.func_175672_r(pos).func_177956_o(), pos.func_177952_p()));
            if (dst != -1.0) {
                if (dst < 32.0) {
                    return false;
                }
                double ideal = ((WorldGenAttributeStructure)this).getIdealDistance();
                chanceMultiplier = ideal / dst;
            } else {
                chanceMultiplier = 0.0;
            }
        }
        return this.cfgEntry.tryGenerate(rand, chanceMultiplier);
    }

    public static interface StructureQuery {
        public StructureBlockArray getStructure();
    }
}

