/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.retrogen;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.world.retrogen.ChunkVersionController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RetroGenController {
    private static boolean inPopulation = false;
    private static Map<Integer, List<ChunkPos>> queuedPopulation = new HashMap<Integer, List<ChunkPos>>();

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        queuedPopulation.remove(event.getWorld().field_73011_w.getDimension());
    }

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        World w = event.getWorld();
        if (w.field_72995_K) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        int dimId = w.field_73011_w.getDimension();
        List queue = queuedPopulation.computeIfAbsent(dimId, id -> new LinkedList());
        queue.add(pos);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load event) {
        World w = event.getWorld();
        if (w.field_72995_K) {
            return;
        }
        ChunkPos pos = event.getChunk().func_76632_l();
        int dimId = w.field_73011_w.getDimension();
        if (!event.getChunk().func_177419_t()) {
            this.visitChunkPopulation(w);
            return;
        }
        List queue = queuedPopulation.computeIfAbsent(dimId, id -> new LinkedList());
        queue.add(pos);
        this.visitChunkPopulation(w);
    }

    private void visitChunkPopulation(World w) {
        if (inPopulation) {
            return;
        }
        int dimId = w.field_73011_w.getDimension();
        List queue = queuedPopulation.computeIfAbsent(dimId, id -> new LinkedList());
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            ChunkPos pos = (ChunkPos)iterator.next();
            int chX = pos.field_77276_a;
            int chZ = pos.field_77275_b;
            if (!w.func_190526_b(chX + 1, chZ) || !w.func_190526_b(chX, chZ + 1) || !w.func_190526_b(chX + 1, chZ + 1)) continue;
            Integer chunkVersion = -1;
            if (((WorldServer)w).func_72863_F().field_73247_e.func_191063_a(pos.field_77276_a, pos.field_77275_b) && (chunkVersion = ChunkVersionController.instance.getGenerationVersion(pos)) == null) {
                return;
            }
            inPopulation = true;
            CommonProxy.worldGenerator.handleRetroGen(w, pos, chunkVersion);
            inPopulation = false;
            iterator.remove();
        }
    }
}

