/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.compat.crafttweaker;

import crafttweaker.IAction;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AddRecipeAction<R extends IForgeRegistryEntry<R>>
implements IAction {
    private final R recipe;
    private final Map<ResourceLocation, R> registry;
    private String desc;
    private Function<R, String> outputAccessor;

    public AddRecipeAction(R recipe, Map<ResourceLocation, R> registry) {
        this.recipe = recipe;
        this.registry = registry;
    }

    public void apply() {
        this.registry.put(this.recipe.getRegistryName(), this.recipe);
    }

    public String describe() {
        if (this.desc != null && this.outputAccessor != null) {
            return String.format("Adding %s recipe %s for %s", this.desc, this.recipe.getRegistryName(), this.outputAccessor.apply(this.recipe));
        }
        return String.format("WARNING, Invalid use of AddRecipeAction!!!, Adding avaritia recipe for the recipe class %s: ", this.recipe.getClass().getName());
    }

    public void setOutputAccessor(Function<R, String> outputAccessor) {
        this.outputAccessor = outputAccessor;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

