/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.recipe.extreme;

import codechicken.lib.reflect.ObfMapping;
import codechicken.lib.reflect.ReflectionManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import morph.avaritia.recipe.extreme.ExtremeShapedRecipe;
import morph.avaritia.recipe.extreme.ExtremeShapelessRecipe;
import morph.avaritia.recipe.extreme.IExtremeRecipe;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ExtremeCraftingManager {
    public static final RegistryNamespaced<ResourceLocation, IExtremeRecipe> REGISTRY = new RegistryNamespaced();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<ResourceLocation, BiFunction<JsonContext, JsonObject, IExtremeRecipe>> recipeFactories = new HashMap<ResourceLocation, BiFunction<JsonContext, JsonObject, IExtremeRecipe>>();
    private static final ObfMapping mapping = new ObfMapping("net/minecraftforge/common/crafting/JsonContext", "loadConstants", "([Lcom/google/gson/JsonObject;)V");
    private static final BiConsumer<JsonContext, JsonObject[]> callLoadContext = (ctx, json) -> ReflectionManager.callMethod((ObfMapping)mapping, null, (Object)ctx, (Object[])new Object[]{json});

    public static void init() {
        recipeFactories.put(new ResourceLocation("avaritia:shaped"), ExtremeShapedRecipe::fromJson);
        recipeFactories.put(new ResourceLocation("avaritia:shapeless"), ExtremeShapelessRecipe::fromJson);
        ModContainer me = Loader.instance().activeModContainer();
        Loader.instance().setActiveModContainer(null);
        Loader.instance().getActiveModList().forEach(ExtremeCraftingManager::loadRecipes);
        Loader.instance().setActiveModContainer(me);
    }

    private static void loadRecipes(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/recipes"), root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(fPath);
                    JsonObject[] json = (JsonObject[])JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject[].class);
                    callLoadContext.accept(ctx, json);
                }
                catch (IOException e) {
                    FMLLog.log.error("Error loading _constants.json: ", (Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            ResourceLocation key = new ResourceLocation(ctx.getModId(), name);
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
                if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)JsonUtils.func_151214_t((JsonObject)json, (String)"conditions"), (JsonContext)ctx)) {
                    Boolean bl = true;
                    return bl;
                }
                IExtremeRecipe recipe = ExtremeCraftingManager.getExtremeRecipe(json, ctx);
                REGISTRY.func_82595_a((Object)key, recipe.setRegistryName(key));
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error loading recipe {}", (Object)key, (Object)e);
                Boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read recipe {} from {}", (Object)key, file, (Object)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        });
    }

    public static IExtremeRecipe getExtremeRecipe(JsonObject obj, JsonContext ctx) {
        if (obj == null || obj.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("getRecipe Context cannot be null");
        }
        String type = ctx.appendModId(JsonUtils.func_151200_h((JsonObject)obj, (String)"type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Recipe type can not be an empty string");
        }
        BiFunction<JsonContext, JsonObject, IExtremeRecipe> factory = recipeFactories.get(new ResourceLocation(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown recipe type: " + type);
        }
        return factory.apply(ctx, obj);
    }
}

