/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.tile;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.BlockUtils;
import codechicken.lib.util.CommonUtils;
import morph.avaritia.network.NetworkDispatcher;
import morph.avaritia.tile.TileBase;
import morph.avaritia.util.TimeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileMachineBase
extends TileBase
implements ITickable {
    protected boolean isActive;
    private boolean wasActive;
    protected TimeTracker offTracker = new TimeTracker();
    private boolean sendUpdatePacket;
    public boolean fullContainerSync;
    protected EnumFacing facing = EnumFacing.NORTH;

    public final void func_73660_a() {
        if (CommonUtils.isClientWorld((World)this.field_145850_b)) {
            return;
        }
        if (this.canWork()) {
            if (!this.isActive && !this.wasActive) {
                this.sendUpdatePacket = true;
            }
            this.isActive = true;
            this.wasActive = false;
            this.doWork();
        } else {
            if (this.isActive) {
                this.onWorkStopped();
                this.wasActive = true;
                if (this.field_145850_b != null) {
                    this.offTracker.markTime(this.field_145850_b);
                }
            }
            this.isActive = false;
        }
        this.updateCheck();
    }

    private void updateCheck() {
        if (this.wasActive && this.offTracker.hasDelayPassed(this.field_145850_b, 100)) {
            this.wasActive = false;
            this.sendUpdatePacket = true;
        }
        if (this.sendUpdatePacket) {
            this.sendUpdatePacket = false;
            NetworkDispatcher.dispatchMachineUpdate(this);
        }
    }

    public void writeUpdateData(PacketCustom packet) {
        packet.writeBoolean(this.isActive);
        packet.writeByte(this.facing.ordinal());
    }

    public void readUpdatePacket(PacketCustom packet) {
        this.isActive = packet.readBoolean();
        this.facing = EnumFacing.field_82609_l[packet.readUByte()];
        BlockUtils.fireBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v());
    }

    public abstract void writeGuiData(PacketCustom var1, boolean var2);

    public abstract void readGuiData(PacketCustom var1, boolean var2);

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        return super.func_189515_b(compound);
    }

    protected abstract boolean canWork();

    protected abstract void doWork();

    protected abstract void onWorkStopped();

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

