/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.tile;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import morph.avaritia.recipe.AvaritiaRecipeManager;
import morph.avaritia.recipe.compressor.ICompressorRecipe;
import morph.avaritia.tile.TileMachineBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileNeutroniumCompressor
extends TileMachineBase
implements ISidedInventory {
    public static int CONSUME_TICKS = 1;
    private int consumption_progress;
    private int compression_progress;
    private ItemStack target_stack = ItemStack.field_190927_a;
    private int compression_target;
    private ItemStack input = ItemStack.field_190927_a;
    private ItemStack output = ItemStack.field_190927_a;
    private List<ItemStack> c_InputItems;
    private static final int[] top = new int[]{0};
    private static final int[] sides = new int[]{1};

    @Override
    public void doWork() {
        boolean dirty = false;
        if (this.target_stack.func_190926_b()) {
            this.fullContainerSync = true;
            ICompressorRecipe recipe = AvaritiaRecipeManager.getCompressorRecipeFromInput(this.input);
            this.target_stack = recipe.getResult();
            this.compression_target = recipe.getCost();
        }
        ++this.consumption_progress;
        if (this.consumption_progress == CONSUME_TICKS) {
            this.consumption_progress = 0;
            this.input.func_190918_g(1);
            if (this.input.func_190916_E() == 0) {
                this.input = ItemStack.field_190927_a;
            }
            ++this.compression_progress;
            dirty = true;
        }
        if (this.compression_progress >= this.compression_target) {
            this.compression_progress = 0;
            if (this.output.func_190926_b()) {
                this.output = ItemUtils.copyStack((ItemStack)this.target_stack, (int)1);
            } else {
                this.output.func_190917_f(1);
            }
            dirty = true;
            this.target_stack = ItemStack.field_190927_a;
            this.fullContainerSync = true;
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    @Override
    protected void onWorkStopped() {
        this.consumption_progress = 0;
    }

    @Override
    protected boolean canWork() {
        if (this.input.func_190926_b()) {
            return false;
        }
        return AvaritiaRecipeManager.hasCompressorRecipe(this.input) && AvaritiaRecipeManager.hasCompressorRecipe(this.input, this.target_stack) && (this.output.func_190926_b() || this.output.func_190916_E() < Math.min(this.output.func_77976_d(), this.func_70297_j_()));
    }

    @Override
    public void writeGuiData(PacketCustom packet, boolean isFullSync) {
        packet.writeVarInt(this.consumption_progress);
        packet.writeVarInt(this.compression_progress);
        if (isFullSync) {
            packet.writeBoolean(!this.target_stack.func_190926_b());
            if (!this.target_stack.func_190926_b()) {
                packet.writeVarInt(this.compression_target);
                packet.writeItemStack(this.target_stack);
            }
            List<Object> ings = Collections.emptyList();
            if (!this.target_stack.func_190926_b()) {
                ings = AvaritiaRecipeManager.getCompressorRecipeFromResult(this.target_stack).getIngredients();
            }
            List inputs = ings.stream().flatMap(l -> Arrays.stream(l.func_193365_a())).collect(Collectors.toList());
            packet.writeInt(inputs.size());
            for (ItemStack input : inputs) {
                packet.writeItemStack(input);
            }
        }
    }

    @Override
    public void readGuiData(PacketCustom packet, boolean isFullSync) {
        this.consumption_progress = packet.readVarInt();
        this.compression_progress = packet.readVarInt();
        if (isFullSync) {
            if (packet.readBoolean()) {
                this.compression_target = packet.readVarInt();
                this.target_stack = packet.readItemStack();
            } else {
                this.target_stack = ItemStack.field_190927_a;
                this.compression_target = 0;
            }
            LinkedList<ItemStack> inputs = new LinkedList<ItemStack>();
            int items = packet.readInt();
            for (int i = 0; i < items; ++i) {
                inputs.add(packet.readItemStack());
            }
            this.c_InputItems = inputs;
        }
    }

    public int getCompressionProgress() {
        return this.compression_progress;
    }

    public int getCompressionTarget() {
        return this.compression_target;
    }

    public int getConsumptionProgress() {
        return this.consumption_progress;
    }

    public int getConsumptionTarget() {
        return CONSUME_TICKS;
    }

    public ItemStack getTargetStack() {
        return this.target_stack;
    }

    public List<ItemStack> getInputItems() {
        return this.c_InputItems;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.input = new ItemStack(tag.func_74775_l("input"));
        this.output = new ItemStack(tag.func_74775_l("output"));
        this.consumption_progress = tag.func_74762_e("consumption_progress");
        this.compression_progress = tag.func_74762_e("compression_progress");
        this.target_stack = new ItemStack(tag.func_74775_l("target"));
        if (!this.target_stack.func_190926_b()) {
            this.compression_target = AvaritiaRecipeManager.getCompressorRecipeFromResult(this.target_stack).getCost();
        }
        this.fullContainerSync = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (!this.input.func_190926_b()) {
            NBTTagCompound inputTag = new NBTTagCompound();
            this.input.func_77955_b(inputTag);
            tag.func_74782_a("input", (NBTBase)inputTag);
        }
        if (!this.output.func_190926_b()) {
            NBTTagCompound outputTag = new NBTTagCompound();
            this.output.func_77955_b(outputTag);
            tag.func_74782_a("output", (NBTBase)outputTag);
        }
        if (!this.target_stack.func_190926_b()) {
            NBTTagCompound targetTag = new NBTTagCompound();
            this.target_stack.func_77955_b(targetTag);
            tag.func_74782_a("target", (NBTBase)targetTag);
        }
        tag.func_74768_a("consumption_progress", this.consumption_progress);
        tag.func_74768_a("compression_progress", this.compression_progress);
        return super.func_189515_b(tag);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side != null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new SidedInvWrapper((ISidedInventory)this, side));
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this));
        }
        return (T)super.getCapability(capability, side);
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        return this.input.func_190926_b() && this.output.func_190926_b();
    }

    public ItemStack func_70301_a(int slot) {
        if (slot == 0) {
            return this.input;
        }
        return this.output;
    }

    public ItemStack func_70298_a(int slot, int decrement) {
        if (slot == 0) {
            if (this.input.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (decrement < this.input.func_190916_E()) {
                ItemStack take = this.input.func_77979_a(decrement);
                if (this.input.func_190916_E() <= 0) {
                    this.input = ItemStack.field_190927_a;
                }
                return take;
            }
            ItemStack take = this.input;
            this.input = ItemStack.field_190927_a;
            return take;
        }
        if (slot == 1) {
            if (this.output.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (decrement < this.output.func_190916_E()) {
                ItemStack take = this.output.func_77979_a(decrement);
                if (this.output.func_190916_E() <= 0) {
                    this.output = ItemStack.field_190927_a;
                }
                return take;
            }
            ItemStack take = this.output;
            this.output = ItemStack.field_190927_a;
            return take;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0) {
            if (this.target_stack.func_190926_b()) {
                return true;
            }
            if (AvaritiaRecipeManager.hasCompressorRecipe(stack) && AvaritiaRecipeManager.getCompressorRecipeFromInput(stack).getResult().func_77969_a(this.target_stack)) {
                return true;
            }
        }
        return false;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.input = stack;
        } else if (slot == 1) {
            this.output = stack;
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return top;
        }
        return sides;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1 && side != EnumFacing.UP;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public int func_70297_j_() {
        return 64;
    }

    public String func_70005_c_() {
        return "container.neutronium_compressor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

