/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import wanion.unidict.UniDict;
import wanion.unidict.resource.Resource;

public class UniDictAPI
implements UniDict.IDependency {
    public final Collection<Resource> resources;
    private final Map<String, Resource> resourceMap;

    public UniDictAPI(@Nonnull Map<String, Resource> resourceMap) {
        this.resourceMap = resourceMap;
        this.resources = this.resourceMap.values();
    }

    @Nonnull
    public static Map<String, Resource> toResourceMap(@Nonnull List<Resource> resources) {
        return resources.stream().collect(Collectors.toMap(Resource::getName, Function.identity()));
    }

    public Resource getResource(@Nonnull String resourceName) {
        return this.resourceMap.get(resourceName);
    }

    public List<Resource> getResources(String ... kinds) {
        return Resource.getResources(this.resources, kinds);
    }

    public List<Resource> getResources(int ... kinds) {
        return Resource.getResources(this.resources, kinds);
    }
}

