/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.common;

import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import wanion.lib.common.MetaItem;
import wanion.unidict.Config;
import wanion.unidict.UniDict;
import wanion.unidict.resource.Resource;
import wanion.unidict.resource.ResourceHandler;

public final class Util {
    public static final Comparator<ItemStack> itemStackComparatorByModName = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            String stack1ModName = wanion.lib.common.Util.getModName((ItemStack)itemStack1);
            Config config = UniDict.getConfig();
            if (config.keepOneEntry && config.keepOneEntryModBlackSet.contains(stack1ModName)) {
                ResourceHandler.addToKeepOneEntryModBlackSet(itemStack1);
            }
            return this.getIndex(stack1ModName) < this.getIndex(itemStack2) ? -1 : 0;
        }

        private long getIndex(ItemStack itemStack) {
            return UniDict.getConfig().ownerOfEveryThing.get((Object)wanion.lib.common.Util.getModName((ItemStack)itemStack));
        }

        private long getIndex(String modName) {
            return UniDict.getConfig().ownerOfEveryThing.get((Object)modName);
        }
    };

    private Util() {
    }

    public static int getCumulative(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        int cumulativeKey = 0;
        for (Object object : objects) {
            if (object instanceof ItemStack) {
                cumulativeKey += MetaItem.get((ItemStack)resourceHandler.getMainItemStack((ItemStack)object));
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty()) continue;
            cumulativeKey += MetaItem.get((ItemStack)((ItemStack)((List)object).get(0)));
        }
        return cumulativeKey;
    }

    public static TIntList getList(@Nonnull Object[] objects, @Nonnull ResourceHandler resourceHandler) {
        TIntArrayList keys = new TIntArrayList();
        for (Object object : objects) {
            int bufKey;
            if (object instanceof ItemStack) {
                bufKey = MetaItem.get((ItemStack)resourceHandler.getMainItemStack((ItemStack)object));
                if (bufKey <= 0) continue;
                keys.add(bufKey);
                continue;
            }
            if (object instanceof Ingredient && ((Ingredient)object).func_193365_a().length > 0) {
                bufKey = MetaItem.get((ItemStack)resourceHandler.getMainItemStack(((Ingredient)object).func_193365_a()[0]));
                if (bufKey <= 0) continue;
                keys.add(bufKey);
                continue;
            }
            if (!(object instanceof List) || ((List)object).isEmpty() || (bufKey = MetaItem.get((ItemStack)((ItemStack)((List)object).get(0)))) <= 0) continue;
            keys.add(bufKey);
        }
        return keys;
    }

    public static TIntList getList(@Nonnull List<?> objects, @Nonnull ResourceHandler resourceHandler) {
        return Util.getList(objects.toArray(), resourceHandler);
    }

    public static TIntSet getSet(@Nonnull Collection<Resource> resourceCollection, int kind) {
        TIntHashSet keys = new TIntHashSet();
        resourceCollection.stream().filter(resource -> resource.childExists(kind)).forEach(arg_0 -> Util.lambda$getSet$1((TIntSet)keys, kind, arg_0));
        return keys;
    }

    private static /* synthetic */ void lambda$getSet$1(TIntSet keys, int kind, Resource resource) {
        keys.addAll((TIntCollection)MetaItem.getList(resource.getChild(kind).getEntries()));
    }
}

