/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import appeng.api.AEApi;
import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IGrinderRegistry;
import appeng.core.features.registries.grinder.AppEngGrinderRecipe;
import appeng.core.features.registries.grinder.GrinderRecipeManager;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import wanion.lib.common.MetaItem;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;

final class AE2Integration
extends AbstractIntegrationThread {
    AE2Integration() {
        super("Applied Energistics 2");
    }

    public String call() {
        try {
            this.fixGrindStoneRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "The world of energistics has never been so powerful.";
    }

    private void fixGrindStoneRecipes() throws NoSuchMethodException {
        Map grindStoneRecipes = (Map)Util.getField(GrinderRecipeManager.class, (String)"recipes", (Object)AEApi.instance().registries().grinder(), Map.class);
        ArrayList<GrinderRecipeWrapper> newRecipes = new ArrayList<GrinderRecipeWrapper>();
        TIntHashSet uniques = new TIntHashSet(grindStoneRecipes.size(), 1.0f);
        Iterator grindStoneRecipeIterator = grindStoneRecipes.entrySet().iterator();
        while (grindStoneRecipeIterator.hasNext()) {
            Map.Entry grindStoneEntry = grindStoneRecipeIterator.next();
            IGrinderRecipe grindStoneRecipe = (IGrinderRecipe)grindStoneEntry.getValue();
            ItemStack correctOutput = this.resourceHandler.getMainItemStack(grindStoneRecipe.getOutput());
            if (correctOutput == grindStoneRecipe.getOutput()) continue;
            ItemStack inputStack = this.config.keepOneEntry ? this.resourceHandler.getMainItemStack(grindStoneRecipe.getInput()) : grindStoneRecipe.getInput();
            int recipeKey = MetaItem.getCumulative((ItemStack[])new ItemStack[]{inputStack, correctOutput});
            if (!uniques.contains(recipeKey)) {
                uniques.add(recipeKey);
                newRecipes.add(new GrinderRecipeWrapper(inputStack, this.resourceHandler.getMainItemStack(grindStoneRecipe.getOutput()), grindStoneRecipe.getOptionalOutput().isPresent() ? this.resourceHandler.getMainItemStack((ItemStack)grindStoneRecipe.getOptionalOutput().get()) : null, grindStoneRecipe.getOptionalChance(), grindStoneRecipe.getSecondOptionalOutput().isPresent() ? this.resourceHandler.getMainItemStack((ItemStack)grindStoneRecipe.getSecondOptionalOutput().get()) : null, grindStoneRecipe.getSecondOptionalChance(), grindStoneRecipe.getRequiredTurns()));
            }
            grindStoneRecipeIterator.remove();
        }
        IGrinderRegistry grinderRecipeManager = AEApi.instance().registries().grinder();
        Class<AppEngGrinderRecipe> appEngGrinderRecipeClass = AppEngGrinderRecipe.class;
        Constructor appEngGrinderNormalRecipeConstructor = appEngGrinderRecipeClass.getDeclaredConstructor(ItemStack.class, ItemStack.class, Integer.TYPE);
        Constructor appEngGrinderOptionalRecipeConstructor = appEngGrinderRecipeClass.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, Float.TYPE, Integer.TYPE);
        Constructor appEngGrinderTwoOptionalRecipeConstructor = appEngGrinderRecipeClass.getDeclaredConstructor(ItemStack.class, ItemStack.class, ItemStack.class, ItemStack.class, Float.TYPE, Float.TYPE, Integer.TYPE);
        appEngGrinderNormalRecipeConstructor.setAccessible(true);
        appEngGrinderOptionalRecipeConstructor.setAccessible(true);
        appEngGrinderTwoOptionalRecipeConstructor.setAccessible(true);
        newRecipes.forEach(grinderRecipeWrapper -> {
            try {
                if (((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput == null && ((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput2 == null) {
                    grinderRecipeManager.addRecipe((IGrinderRecipe)appEngGrinderNormalRecipeConstructor.newInstance(((GrinderRecipeWrapper)grinderRecipeWrapper).input, ((GrinderRecipeWrapper)grinderRecipeWrapper).output, ((GrinderRecipeWrapper)grinderRecipeWrapper).cost));
                } else if (((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput != null && ((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput2 == null) {
                    grinderRecipeManager.addRecipe((IGrinderRecipe)appEngGrinderOptionalRecipeConstructor.newInstance(((GrinderRecipeWrapper)grinderRecipeWrapper).input, ((GrinderRecipeWrapper)grinderRecipeWrapper).output, ((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput, Float.valueOf(((GrinderRecipeWrapper)grinderRecipeWrapper).optionalChance), ((GrinderRecipeWrapper)grinderRecipeWrapper).cost));
                } else if (((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput != null) {
                    grinderRecipeManager.addRecipe((IGrinderRecipe)appEngGrinderTwoOptionalRecipeConstructor.newInstance(((GrinderRecipeWrapper)grinderRecipeWrapper).input, ((GrinderRecipeWrapper)grinderRecipeWrapper).output, ((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput, Float.valueOf(((GrinderRecipeWrapper)grinderRecipeWrapper).optionalChance), ((GrinderRecipeWrapper)grinderRecipeWrapper).optionalOutput2, Float.valueOf(((GrinderRecipeWrapper)grinderRecipeWrapper).optionalChance2), ((GrinderRecipeWrapper)grinderRecipeWrapper).cost));
                }
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    private static class GrinderRecipeWrapper {
        private final ItemStack input;
        private final ItemStack output;
        private final ItemStack optionalOutput;
        private final ItemStack optionalOutput2;
        private final float optionalChance;
        private final float optionalChance2;
        private final int cost;

        private GrinderRecipeWrapper(ItemStack input, ItemStack output, ItemStack optionalOutput, float optionalChance, ItemStack optionalOutput2, float optionalChance2, int cost) {
            this.input = input;
            this.output = output;
            this.optionalOutput = optionalOutput;
            this.optionalOutput2 = optionalOutput2;
            this.optionalChance = optionalChance;
            this.optionalChance2 = optionalChance2;
            this.cost = cost;
        }
    }
}

