/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.registry.recipe.ArbitraryCrusherRecipe;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import com.mcmoddev.lib.registry.recipe.OreDictionaryCrusherRecipe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import wanion.lib.common.Util;
import wanion.unidict.integration.AbstractIntegrationThread;

final class BaseMetalsIntegration
extends AbstractIntegrationThread {
    BaseMetalsIntegration() {
        super("Base Metals");
    }

    public String call() {
        this.fixCrushingRecipes();
        return this.threadName + "Fixing Everything!";
    }

    private void fixCrushingRecipes() {
        CrusherRecipeRegistry crusherRecipeRegistry = (CrusherRecipeRegistry)Util.getField(CrusherRecipeRegistry.class, (String)"instance", null, CrusherRecipeRegistry.class);
        IForgeRegistryModifiable registry = (IForgeRegistryModifiable)Util.getField(CrusherRecipeRegistry.class, (String)"registry", (Object)crusherRecipeRegistry, IForgeRegistryModifiable.class);
        ArrayList recipesToRemove = new ArrayList();
        ArrayList newRecipes = new ArrayList();
        registry.getEntries().forEach(recipe -> {
            ItemStack newOutput;
            ICrusherRecipe crusherRecipe = (ICrusherRecipe)recipe.getValue();
            ItemStack output = crusherRecipe.getOutput();
            if (output != (newOutput = this.resourceHandler.getMainItemStack(crusherRecipe.getOutput()))) {
                recipesToRemove.add(recipe.getKey());
                if (crusherRecipe instanceof ArbitraryCrusherRecipe) {
                    newRecipes.add(new ArbitraryCrusherRecipe((ItemStack)crusherRecipe.getInputs().get(0), newOutput));
                } else if (crusherRecipe instanceof OreDictionaryCrusherRecipe) {
                    newRecipes.add(new OreDictionaryCrusherRecipe((String)Util.getField(OreDictionaryCrusherRecipe.class, (String)"oreDictSource", (Object)crusherRecipe, String.class), newOutput));
                }
            }
        });
        recipesToRemove.forEach(arg_0 -> ((IForgeRegistryModifiable)registry).remove(arg_0));
        newRecipes.forEach(arg_0 -> ((IForgeRegistryModifiable)registry).register(arg_0));
    }
}

