/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipe;
import forestry.factory.recipes.CentrifugeRecipeManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import wanion.lib.common.MetaItem;
import wanion.lib.common.Util;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class ForestryIntegration
extends AbstractIntegrationThread {
    private Set<ICarpenterRecipe> carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, (String)"recipes", null, Set.class);

    ForestryIntegration() {
        super("Forestry");
    }

    public String call() {
        try {
            this.removeBadCarpenterOutputs(this.carpenterRecipes);
            if (this.resourceHandler.containerExists("ingotBronze")) {
                this.bronzeThings();
            }
            this.fixCentrifugeRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "All these bees... they can hurt, you know?";
    }

    private void removeBadCarpenterOutputs(@Nonnull Set<ICarpenterRecipe> carpenterRecipes) {
        carpenterRecipes.removeIf(carpenterRecipe -> carpenterRecipe != null && this.resourceHandler.exists(MetaItem.get((ItemStack)carpenterRecipe.getCraftingGridRecipe().getOutput())));
    }

    private void bronzeThings() {
        UniResourceContainer ingotBronze = this.resourceHandler.getContainer("ingotBronze");
        Item brokenBronzePickaxe = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("forestry", "brokenBronzePickaxe"));
        Item brokenBronzeShovel = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("forestry", "brokenBronzeShovel"));
        if (brokenBronzePickaxe != null) {
            this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, ItemStack.field_190927_a, new ShapedRecipeCustom(ingotBronze.getMainEntry(2), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack(brokenBronzePickaxe)})));
        }
        if (brokenBronzeShovel != null) {
            this.carpenterRecipes.add((ICarpenterRecipe)new CarpenterRecipe(5, null, ItemStack.field_190927_a, new ShapedRecipeCustom(ingotBronze.getMainEntry(1), new Object[]{"X  ", "   ", "   ", Character.valueOf('X'), new ItemStack(brokenBronzeShovel)})));
        }
    }

    private void fixCentrifugeRecipes() {
        Set centrifugeRecipes = (Set)Util.getField(CentrifugeRecipeManager.class, (String)"recipes", null, Set.class);
        if (centrifugeRecipes == null) {
            return;
        }
        ArrayList<CentrifugeRecipe> newRecipes = new ArrayList<CentrifugeRecipe>();
        Iterator centrifugeRecipeIterator = centrifugeRecipes.iterator();
        while (centrifugeRecipeIterator.hasNext()) {
            ICentrifugeRecipe centrifugeRecipe = (ICentrifugeRecipe)centrifugeRecipeIterator.next();
            newRecipes.add(new CentrifugeRecipe(centrifugeRecipe.getProcessingTime(), centrifugeRecipe.getInput(), this.correctCentrifugeOutput(centrifugeRecipe.getAllProducts())));
            centrifugeRecipeIterator.remove();
        }
        centrifugeRecipes.addAll(newRecipes);
    }

    @Nonnull
    private Map<ItemStack, Float> correctCentrifugeOutput(@Nonnull Map<ItemStack, Float> outputMap) {
        HashMap<ItemStack, Float> newOutputMap = new HashMap<ItemStack, Float>();
        outputMap.forEach((output, chance) -> newOutputMap.put(this.resourceHandler.getMainItemStack((ItemStack)output), (Float)chance));
        return newOutputMap;
    }
}

