/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import wanion.unidict.UniDict;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class FurnaceIntegration
extends AbstractIntegrationThread {
    private static final Field experienceListField;

    FurnaceIntegration() {
        super("Furnace");
    }

    public String call() {
        try {
            this.optimizeFurnaceRecipes();
        }
        catch (Exception e) {
            UniDict.getLogger().error(this.threadName + e);
        }
        return this.threadName + "Some things that you smelted appear to be different now.";
    }

    private void optimizeFurnaceRecipes() {
        Map experienceMap;
        try {
            experienceMap = (Map)experienceListField.get(FurnaceRecipes.func_77602_a());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Furnace Integration Couldn't find a required field.");
        }
        if (!this.config.inputReplacementFurnace) {
            for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
                ItemStack oldEntry = (ItemStack)entry.getValue();
                ItemStack newEntry = this.resourceHandler.getMainItemStack(oldEntry);
                entry.setValue(newEntry);
                if (!experienceMap.containsKey(oldEntry)) continue;
                experienceMap.put(newEntry, experienceMap.remove(oldEntry));
            }
        } else {
            IdentityHashMap<UniResourceContainer, TIntHashSet> containerKindMap = new IdentityHashMap<UniResourceContainer, TIntHashSet>();
            Map map = FurnaceRecipes.func_77602_a().func_77599_b();
            HashMap<ItemStack, ItemStack> newRecipes = new HashMap<ItemStack, ItemStack>();
            Iterator furnaceRecipeIterator = map.entrySet().iterator();
            while (furnaceRecipeIterator.hasNext()) {
                TIntSet kindSet;
                Map.Entry furnaceRecipe = furnaceRecipeIterator.next();
                UniResourceContainer inputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getKey());
                UniResourceContainer outputContainer = this.resourceHandler.getContainer((ItemStack)furnaceRecipe.getValue());
                if (outputContainer == null) continue;
                if (inputContainer == null) {
                    furnaceRecipe.setValue(outputContainer.getMainEntry(((ItemStack)furnaceRecipe.getValue()).func_190916_E()));
                    continue;
                }
                int kind = inputContainer.kind;
                ItemStack oldEntry = (ItemStack)furnaceRecipe.getValue();
                if (!containerKindMap.containsKey(outputContainer)) {
                    containerKindMap.put(outputContainer, new TIntHashSet());
                }
                if (!(kindSet = (TIntSet)containerKindMap.get(outputContainer)).contains(kind)) {
                    kindSet.add(kind);
                    ItemStack newEntry = outputContainer.getMainEntry(oldEntry.func_190916_E());
                    newRecipes.put(inputContainer.getMainEntry(((ItemStack)furnaceRecipe.getKey()).func_190916_E()), newEntry);
                    if (experienceMap.containsKey(oldEntry)) {
                        experienceMap.put(newEntry, experienceMap.remove(oldEntry));
                    }
                }
                furnaceRecipeIterator.remove();
                experienceMap.remove(oldEntry);
            }
            map.putAll(newRecipes);
        }
    }

    static {
        Field obfuscatedField = null;
        try {
            obfuscatedField = FurnaceRecipes.class.getDeclaredField("field_77605_c");
        }
        catch (NoSuchFieldException e) {
            UniDict.getLogger().debug("Dev-Environment, right?");
        }
        Field deobfuscatedField = null;
        if (obfuscatedField == null) {
            try {
                deobfuscatedField = FurnaceRecipes.class.getDeclaredField("experienceList");
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("UniDict couldn't find the experienceList Field, even you being in an Dev-Environment, please report this.");
            }
        }
        if ((experienceListField = obfuscatedField != null ? obfuscatedField : deobfuscatedField) != null) {
            experienceListField.setAccessible(true);
        }
    }
}

