/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.lib.config.EnumTristate;
import com.feed_the_beast.ftbl.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbu")
@Config(modid="ftbu", category="config", name="../local/ftbutilities/config")
public class FTBUConfig {
    @Config.RequiresWorldRestart
    public static final AutoShutdown auto_shutdown = new AutoShutdown();
    public static final ServerInfo server_info = new ServerInfo();
    public static final Chat chat = new Chat();
    public static final BackupsConfig backups = new BackupsConfig();
    @Config.RequiresWorldRestart
    @Config.LangKey(value="commands")
    public static final Commands commands = new Commands();
    public static final Login login = new Login();
    @Config.RequiresWorldRestart
    public static final RanksConfig ranks = new RanksConfig();
    public static final WorldConfig world = new WorldConfig();

    public static void sync() {
        ConfigManager.sync((String)"ftbu", (Config.Type)Config.Type.INSTANCE);
        login.motdComponents.clear();
        login.startingItems.clear();
        if (FTBUConfig.login.enable_motd) {
            for (String s : FTBUConfig.login.motd) {
                ITextComponent t = JsonUtils.deserializeTextComponent((JsonElement)JsonUtils.fromJson((String)s));
                if (t == null) continue;
                login.motdComponents.add(t);
            }
        }
        if (FTBUConfig.login.enable_starting_items) {
            for (String s : FTBUConfig.login.starting_items) {
                try {
                    ItemStack stack = ItemStackSerializer.parseItem((String)s);
                    if (stack.func_190926_b()) continue;
                    login.startingItems.add(stack);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("ftbu")) {
            FTBUConfig.sync();
        }
    }

    public static class WorldConfig {
        public boolean chunk_claiming = true;
        public boolean chunk_loading = true;
        @Config.Comment(value={"If set to true, explosions and hostile mobs in spawn area will be disabled, players won't be able to attack each other in spawn area"})
        public boolean safe_spawn = false;
        @Config.Comment(value={"Enable spawn area in singleplayer"})
        public boolean spawn_area_in_sp = false;
        @Config.Comment(value={"Print a message in console every time a chunk is forced or unforced. Recommended to be off, because spam"})
        public boolean log_chunkloading = false;
        @Config.Comment(value={"Dimensions where chunk claiming isn't allowed"})
        public int[] blocked_claiming_dimensions = new int[0];
        @Config.Comment(value={"If set to DEFAULT, then players can decide their PVP status"})
        @Config.LangKey(value="player_config.ftbu.enable_pvp")
        public EnumTristate enable_pvp = EnumTristate.DEFAULT;
        @Config.Comment(value={"If set to DEFAULT, then teams can decide their Explosion setting"})
        @Config.LangKey(value="team_config.ftbu.explosions")
        public EnumTristate enable_explosions = EnumTristate.DEFAULT;

        public boolean allowDimension(int dimension) {
            if (!FTBUConfig.world.chunk_claiming) {
                return false;
            }
            if (this.blocked_claiming_dimensions.length > 0) {
                for (int i : this.blocked_claiming_dimensions) {
                    if (i != dimension) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class RanksConfig {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        @Config.RequiresMcRestart
        public boolean enabled = true;
        public boolean override_chat = true;
        public boolean override_commands = true;
    }

    public static class Login {
        public boolean enable_motd = false;
        public boolean enable_starting_items = false;
        @Config.Comment(value={"Set to false to disable global badges completely, only server-wide badges will be available"})
        public boolean enable_global_badges = true;
        @Config.Comment(value={"Set to false to disable event badges, e.g. Halloween"})
        public boolean enable_event_badges = true;
        @Config.Comment(value={"Message of the day. This will be displayed when player joins the server"})
        public String[] motd = new String[]{"\"Hello player!\""};
        private List<ITextComponent> motdComponents = new ArrayList<ITextComponent>();
        private List<ItemStack> startingItems = new ArrayList<ItemStack>();
        @Config.Comment(value={"Items to give player when he first joins the server", "Format: '{id:\"ID\",Count:X,Damage:X,tag:{}}'"})
        public String[] starting_items = new String[]{"{id:\"minecraft:stone_sword\",Count:1,Damage:1,tag:{display:{Name:\"Epic Stone Sword\"}}}"};

        public List<ITextComponent> getMOTD() {
            return this.motdComponents;
        }

        public List<ItemStack> getStartingItems() {
            return this.startingItems;
        }
    }

    public static class Commands {
        public boolean warp = true;
        public boolean home = true;
        public boolean back = true;
        public boolean spawn = true;
        public boolean inv = true;
        public boolean tpl = true;
        public boolean trash_can = true;
        public boolean chunks = true;
        public boolean kickme = true;
        public boolean ranks = true;
        public boolean heal = true;
        public boolean set_hour = true;
        public boolean killall = true;
        public boolean nbtedit = true;
        public boolean view_crash = true;
        public boolean fly = true;
        public boolean leaderboard = true;
    }

    public static class BackupsConfig {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        public boolean enabled = true;
        public boolean silent = false;
        @Config.RangeInt(min=0, max=32000)
        @Config.Comment(value={"The number of backup files to keep", "More backups = more space used", "0 - Infinite"})
        public int backups_to_keep = 12;
        @Config.RangeDouble(min=0.05, max=600.0)
        @Config.Comment(value={"Timer in hours", "1.0 - backups every hour", "6.0 - backups every 6 hours", "0.5 - backups every 30 minutes"})
        public double backup_timer = 2.0;
        @Config.RangeInt(min=0, max=9)
        @Config.Comment(value={"0 - Disabled (output = folders)", "1 - Best speed", "9 - Smallest file size"})
        public int compression_level = 1;
        @Config.Comment(value={"Absolute path to backups folder"})
        public String folder = "";
        @Config.Comment(value={"Prints (current size | total size) when backup is done"})
        public boolean display_file_size = true;
        @Config.Comment(value={"Run backup in a separated Thread (recommended)"})
        public boolean use_separate_thread = true;

        public long ticks() {
            return (long)(this.backup_timer * 72000.0);
        }
    }

    public static class Chat {
        @Config.RangeInt(min=0, max=10000000)
        public int general_history_limit = 10000;
        @Config.RangeInt(min=0, max=10000000)
        public int team_history_limit = 1000;
        @Config.RangeInt(min=0, max=10000000)
        public int admin_history_limit = 10000;
    }

    public static class ServerInfo {
        public boolean difficulty = true;
        @Config.LangKey(value="ftbu.config.login.motd")
        public boolean motd = true;
    }

    public static class AutoShutdown {
        @Config.LangKey(value="addServer.resourcePack.enabled")
        public boolean enabled = false;
        @Config.Comment(value={"Server will automatically shut down after X hours", "Time Format: HH:MM. If the system time matches a value, server will shut down", "It will look for closest value available that is not equal to current time"})
        public String[] times = new String[]{"04:00", "16:00"};
    }
}

