/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.api.PermissionRegistryEvent;
import com.feed_the_beast.ftbl.api.RegisterRankConfigEvent;
import com.feed_the_beast.ftbl.lib.config.ConfigInt;
import com.feed_the_beast.ftbl.lib.config.ConfigString;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbu.api.NodeEntry;
import com.feed_the_beast.ftbu.api.RegisterCustomPermissionPrefixesEvent;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

@EventHandler
public class FTBUPermissions {
    public static final String DISPLAY_ADMIN_INFO = "ftbu.display.admin_info";
    public static final String BADGE = "ftbu.badge";
    public static final String HOMES_CROSS_DIM = "ftbu.homes.cross_dim";
    public static final String HOMES_MAX = "ftbu.homes.max";
    public static final String HOMES_LIST_OTHER = "ftbu.homes.list_other";
    public static final String HOMES_TELEPORT_OTHER = "ftbu.homes.teleport_other";
    public static final String CLAIMS_CHUNKS_MODIFY_OTHERS = "ftbu.claims.modify.others";
    public static final String CLAIMS_MAX_CHUNKS = "ftbu.claims.max_chunks";
    public static final String CLAIMS_BLOCK_CNB = "ftbu.claims.block.cnb";
    private static final String CLAIMS_BLOCK_EDIT_PREFIX = "ftbu.claims.block.edit.";
    private static final String CLAIMS_BLOCK_INTERACT_PREFIX = "ftbu.claims.block.interact.";
    private static final String CLAIMS_ITEM_PREFIX = "ftbu.claims.item.";
    public static final String INFINITE_BACK_USAGE = "ftbu.back.infinite";
    public static final String CHUNKLOADER_MAX_CHUNKS = "ftbu.chunkloader.max_chunks";
    public static final String CHUNKLOADER_LOAD_OFFLINE = "ftbu.chunkloader.load_offline";

    @SubscribeEvent
    public static void registerPermissions(PermissionRegistryEvent event) {
        String name;
        event.registerNode(DISPLAY_ADMIN_INFO, DefaultPermissionLevel.OP, "Display 'Admin' in Server Info");
        event.registerNode(HOMES_CROSS_DIM, DefaultPermissionLevel.ALL, "Can use /home to teleport to/from another dimension");
        event.registerNode(HOMES_LIST_OTHER, DefaultPermissionLevel.ALL, "");
        event.registerNode(HOMES_TELEPORT_OTHER, DefaultPermissionLevel.ALL, "");
        event.registerNode(CLAIMS_CHUNKS_MODIFY_OTHERS, DefaultPermissionLevel.OP, "Allow player to modify other team chunks");
        event.registerNode(CLAIMS_BLOCK_CNB, DefaultPermissionLevel.OP, "Allow to edit C&B bits in claimed chunks");
        event.registerNode(INFINITE_BACK_USAGE, DefaultPermissionLevel.NONE, "Allow to use 'back' command infinite times");
        event.registerNode(CHUNKLOADER_LOAD_OFFLINE, DefaultPermissionLevel.ALL, "Keep loaded chunks working when player goes offline");
        for (Block block : Block.field_149771_c) {
            name = FTBUPermissions.formatId(block);
            event.registerNode(CLAIMS_BLOCK_EDIT_PREFIX + name, name.startsWith("graves.") || name.startsWith("gravestone.") ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
            event.registerNode(CLAIMS_BLOCK_INTERACT_PREFIX + name, block instanceof BlockDoor || block instanceof BlockWorkbench || block instanceof BlockAnvil ? DefaultPermissionLevel.ALL : DefaultPermissionLevel.OP);
        }
        for (Item item : Item.field_150901_e) {
            name = FTBUPermissions.formatId(item);
            event.registerNode(CLAIMS_ITEM_PREFIX + name, item instanceof ItemBucket ? DefaultPermissionLevel.OP : DefaultPermissionLevel.ALL);
        }
        event.registerNode("ftbu.claims.block.edit.gravestone.gravestone", DefaultPermissionLevel.ALL);
        event.registerNode(CLAIMS_ITEM_PREFIX + FTBUPermissions.formatId(Items.field_185158_cP), DefaultPermissionLevel.OP);
        event.registerNode("ftbu.claims.item.forge.bucketfilled", DefaultPermissionLevel.OP);
    }

    @SubscribeEvent
    public static void addConfigs(RegisterRankConfigEvent event) {
        event.register(BADGE, (ConfigValue)new ConfigString(""), (ConfigValue)new ConfigString(""));
        event.register(HOMES_MAX, (ConfigValue)new ConfigInt(1, 0, 30000), (ConfigValue)new ConfigInt(100));
        event.register(CLAIMS_MAX_CHUNKS, (ConfigValue)new ConfigInt(100, 0, 30000), (ConfigValue)new ConfigInt(1000));
        event.register(CHUNKLOADER_MAX_CHUNKS, (ConfigValue)new ConfigInt(50, 0, 30000), (ConfigValue)new ConfigInt(64));
    }

    @SubscribeEvent
    public static void addCustomPerms(RegisterCustomPermissionPrefixesEvent event) {
        event.register(new NodeEntry("command.", DefaultPermissionLevel.OP, "Permission for commands, if FTBU command overriding is enabled. If not, this node will be inactive"));
        event.register(new NodeEntry(CLAIMS_BLOCK_EDIT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can break and place within claimed chunks"));
        event.register(new NodeEntry(CLAIMS_BLOCK_INTERACT_PREFIX, DefaultPermissionLevel.OP, "Permission for blocks that players can right-click within claimed chunks"));
        event.register(new NodeEntry(CLAIMS_ITEM_PREFIX, DefaultPermissionLevel.ALL, "Permission for items that players can right-click in air within claimed chunks"));
    }

    private static String formatId(@Nullable IForgeRegistryEntry<?> item) {
        return item == null || item.getRegistryName() == null ? "minecraft.air" : item.getRegistryName().toString().toLowerCase().replace(':', '.');
    }

    public static boolean canModifyBlock(EntityPlayerMP player, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        switch (type) {
            case EDIT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_EDIT_PREFIX + FTBUPermissions.formatId(block.getState().func_177230_c())), null);
            }
            case INTERACT: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_BLOCK_INTERACT_PREFIX + FTBUPermissions.formatId(block.getState().func_177230_c())), null);
            }
            case CNB_BREAK: 
            case CNB_PLACE: {
                return PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)CLAIMS_BLOCK_CNB, null);
            }
            case ITEM: {
                return !player.func_184586_b(hand).func_190926_b() || PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)(CLAIMS_ITEM_PREFIX + FTBUPermissions.formatId(player.func_184586_b(hand).func_77973_b())), null);
            }
        }
        return false;
    }
}

