/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu;

import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.TextComponentCountdown;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.net.MessageServerInfo;
import com.feed_the_beast.ftbu.ranks.CmdOverride;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import com.feed_the_beast.ftbu.util.backups.Backups;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.command.CommandTreeBase;

public class ServerInfoPage {
    private static JsonElement serverGuide = null;
    private static final Map<UUID, MessageServerInfo.CommandInfo> COMMAND_CACHE = new HashMap<UUID, MessageServerInfo.CommandInfo>();

    public static void reloadCachedInfo() {
        serverGuide = null;
        COMMAND_CACHE.clear();
    }

    public static JsonElement getServerGuide() {
        if (serverGuide == null) {
            serverGuide = JsonUtils.fromJson((File)new File(CommonUtils.folderLocal, "ftbutilities/server_guide.json"));
        }
        return serverGuide;
    }

    public static MessageServerInfo.CommandInfo getCommands(EntityPlayerMP player) {
        MessageServerInfo.CommandInfo info = COMMAND_CACHE.get(player.func_110124_au());
        if (info == null) {
            info = new MessageServerInfo.CommandInfo("", Collections.emptyList(), new ArrayList<MessageServerInfo.CommandInfo>());
            for (ICommand command : ServerUtils.getAllCommands((MinecraftServer)player.field_71133_b, (ICommandSender)player)) {
                try {
                    ServerInfoPage.addCommandUsage((ICommandSender)player, info, command);
                }
                catch (Exception exception) {}
            }
            COMMAND_CACHE.put(player.func_110124_au(), info);
        }
        return info;
    }

    public static List<ITextComponent> getMainPage(EntityPlayerMP player, long now) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (FTBUUniverseData.shutdownTime > 0L) {
            list.add(FTBULang.TIMER_SHUTDOWN.textComponent((ICommandSender)player, new Object[]{new TextComponentCountdown(FTBUUniverseData.shutdownTime)}));
        }
        if (FTBUConfig.backups.enabled) {
            list.add(FTBULang.TIMER_BACKUP.textComponent((ICommandSender)player, new Object[]{new TextComponentCountdown(Backups.INSTANCE.nextBackup)}));
        }
        if (FTBUConfig.server_info.difficulty) {
            list.add(FTBLibLang.DIFFICULTY.textComponent((ICommandSender)player, new Object[]{StringUtils.firstUppercase((String)player.field_70170_p.func_175659_aa().toString().toLowerCase())}));
        }
        if (FTBUConfig.server_info.motd && !FTBUConfig.login.getMOTD().isEmpty()) {
            list.add(null);
            list.addAll(FTBUConfig.login.getMOTD());
        }
        return list;
    }

    private static void addCommandUsage(ICommandSender sender, MessageServerInfo.CommandInfo parent, ICommand command) {
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        if (!command.func_71514_a().isEmpty()) {
            info.add((ITextComponent)new TextComponentString("/" + command.func_71517_b()));
            for (String s : command.func_71514_a()) {
                info.add((ITextComponent)new TextComponentString("/" + s));
            }
            info.add(null);
        }
        for (String line : command.func_71518_a(sender).split("\n")) {
            if (line.indexOf(37) != -1 || line.indexOf(47) != -1) {
                info.add(FTBLibLang.COMMAND_USAGE.textComponent(sender, new Object[]{line}));
                continue;
            }
            info.add(FTBLibLang.COMMAND_USAGE.textComponent(sender, new Object[]{new TextComponentTranslation(line, new Object[0])}));
        }
        MessageServerInfo.CommandInfo cmd = new MessageServerInfo.CommandInfo(command.func_71517_b(), info, new ArrayList<MessageServerInfo.CommandInfo>());
        CommandTreeBase treeCommand = null;
        if (command instanceof CommandTreeBase) {
            treeCommand = (CommandTreeBase)command;
        } else if (command instanceof CmdOverride && ((CmdOverride)command).parent instanceof CommandTreeBase) {
            treeCommand = (CommandTreeBase)((CmdOverride)command).parent;
        }
        if (treeCommand != null) {
            for (ICommand sub : treeCommand.getSubCommands()) {
                ServerInfoPage.addCommandUsage(sender, cmd, sub);
            }
        }
        parent.subcommands.add(new MessageServerInfo.CommandInfo(cmd.name, cmd.info.isEmpty() ? Collections.emptyList() : cmd.info, cmd.subcommands.isEmpty() ? Collections.emptyList() : cmd.subcommands));
    }
}

