/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Leaderboard
extends IForgeRegistryEntry.Impl<Leaderboard> {
    private final ITextComponent title;
    private final Function<IForgePlayer, ITextComponent> playerToValue;
    private final Comparator<IForgePlayer> comparator;
    private final Predicate<IForgePlayer> validValue;

    public Leaderboard(ITextComponent t, Function<IForgePlayer, ITextComponent> v, Comparator<IForgePlayer> c, Predicate<IForgePlayer> vv) {
        this.title = t;
        this.playerToValue = v;
        this.comparator = c.thenComparing((o1, o2) -> o1.func_176610_l().compareToIgnoreCase(o2.func_176610_l()));
        this.validValue = vv;
    }

    public final ITextComponent getTitle() {
        return this.title;
    }

    public final Comparator<IForgePlayer> getComparator() {
        return this.comparator;
    }

    public final ITextComponent createValue(IForgePlayer player) {
        return this.playerToValue.apply(player);
    }

    public final boolean hasValidValue(IForgePlayer player) {
        return this.validValue.test(player);
    }

    public static class FromStat
    extends Leaderboard {
        public static final IntFunction<ITextComponent> DEFAULT = value -> new TextComponentString(value <= 0 ? "0" : Integer.toString(value));
        public static final IntFunction<ITextComponent> TIME = value -> new TextComponentString("[" + (int)((double)value / 72000.0 + 0.5) + "h] " + StringUtils.getTimeStringTicks((long)value));

        public FromStat(ITextComponent t, StatBase statBase, boolean from0to1, IntFunction<ITextComponent> valueToString) {
            super(t, (IForgePlayer player) -> (ITextComponent)valueToString.apply(player.stats().func_77444_a(statBase)), (o1, o2) -> {
                int i = Integer.compare(o1.stats().func_77444_a(statBase), o2.stats().func_77444_a(statBase));
                return from0to1 ? i : -i;
            }, (IForgePlayer player) -> player.stats().func_77444_a(statBase) > 0);
        }

        public FromStat(StatBase statBase, boolean from0to1, IntFunction<ITextComponent> valueToString) {
            this(StringUtils.color((ITextComponent)statBase.func_150951_e(), null), statBase, from0to1, valueToString);
        }
    }
}

