/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api.guide;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.MapUtils;
import com.feed_the_beast.ftbu.api.guide.GuideType;
import com.feed_the_beast.ftbu.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbu.api.guide.SpecialGuideButton;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.ITextComponent;

public interface IGuidePage
extends IStringSerializable {
    public static final Comparator<Map.Entry<String, IGuidePage>> COMPARATOR = (o1, o2) -> {
        int i = ((IGuidePage)o1.getValue()).getType().compareTo(((IGuidePage)o2.getValue()).getType());
        return i == 0 ? ((IGuidePage)o1.getValue()).getDisplayName().func_150260_c().compareToIgnoreCase(((IGuidePage)o2.getValue()).getDisplayName().func_150260_c()) : i;
    };

    default public GuideType getType() {
        return GuideType.OTHER;
    }

    public void fromJson(JsonObject var1);

    @Nullable
    public IGuidePage getParent();

    default public String getFullId() {
        IGuidePage parent = this.getParent();
        String parentId = parent == null ? "" : parent.getFullId();
        return parentId.isEmpty() ? this.func_176610_l() : parentId + '.' + this.func_176610_l();
    }

    public ITextComponent getDisplayName();

    @Nullable
    public ITextComponent getTitle();

    public IGuidePage setTitle(@Nullable ITextComponent var1);

    public void println(@Nullable Object var1);

    public List<IGuideTextLine> getText();

    public Map<String, IGuidePage> getChildren();

    default public IGuidePage addSub(IGuidePage c) {
        this.getChildren().put(c.func_176610_l(), c);
        return c;
    }

    public IGuidePage getSub(String var1);

    @Nullable
    default public IGuidePage getSubRaw(String id) {
        int i = id.indexOf(46);
        if (i >= 0) {
            IGuidePage page = this.getChildren().get(id.substring(0, i));
            return page == null ? null : page.getSubRaw(id.substring(i + 1));
        }
        return this.getChildren().get(id);
    }

    default public void clear() {
        this.getText().clear();
        this.getChildren().clear();
    }

    default public void cleanup() {
        this.getChildren().values().forEach(IGuidePage::cleanup);
        this.getChildren().values().removeIf(IGuidePage::isEmpty);
    }

    default public boolean isEmpty() {
        if (!this.getChildren().isEmpty()) {
            return false;
        }
        for (IGuideTextLine line : this.getText()) {
            if (line == null || line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public void sort(boolean tree) {
        MapUtils.sortMap(this.getChildren(), COMPARATOR);
        if (tree) {
            this.getChildren().values().forEach(page -> page.sort(true));
        }
    }

    default public void copyFrom(IGuidePage c) {
        for (IGuideTextLine iGuideTextLine : c.getText()) {
            this.getText().add(iGuideTextLine == null ? null : iGuideTextLine.copy(this));
        }
        for (Map.Entry entry : c.getChildren().entrySet()) {
            this.getSub((String)entry.getKey()).copyFrom((IGuidePage)entry.getValue());
        }
    }

    public List<SpecialGuideButton> getSpecialButtons();

    default public IGuidePage addSpecialButton(SpecialGuideButton button) {
        this.getSpecialButtons().add(button);
        return this;
    }

    public IGuidePage setIcon(Icon var1);

    default public Icon getIcon() {
        return Icon.EMPTY;
    }

    public Widget createWidget(GuiBase var1);

    @Nullable
    public IGuideTextLine createLine(@Nullable JsonElement var1);
}

