/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api_impl;

import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrades;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.util.FTBUTeamData;
import java.util.Arrays;
import java.util.HashSet;

public final class ClaimedChunk
implements IClaimedChunk {
    private final ChunkDimPos pos;
    private final FTBUTeamData teamData;
    private ChunkUpgrade[] upgrades;
    private boolean invalid;
    public Boolean forced;

    public ClaimedChunk(ChunkDimPos c, FTBUTeamData t) {
        this.pos = c;
        this.teamData = t;
        this.upgrades = null;
        this.invalid = false;
        this.forced = null;
    }

    @Override
    public boolean isInvalid() {
        return this.invalid || this.teamData == null || this.teamData.team == null || this.teamData.team.getOwner() == null;
    }

    public void setInvalid() {
        this.invalid = true;
    }

    @Override
    public ChunkDimPos getPos() {
        return this.pos;
    }

    @Override
    public IForgeTeam getTeam() {
        return this.teamData.team;
    }

    public FTBUTeamData getData() {
        return this.teamData;
    }

    @Override
    public boolean hasUpgrade(ChunkUpgrade upgrade) {
        if (upgrade == ChunkUpgrades.NO_EXPLOSIONS) {
            return !this.teamData.explosions.getBoolean();
        }
        if (this.upgrades != null && !upgrade.isInternal()) {
            for (ChunkUpgrade upgrade1 : this.upgrades) {
                if (upgrade1 != upgrade) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setHasUpgrade(ChunkUpgrade upgrade, boolean v) {
        boolean changed;
        if (upgrade.isInternal()) {
            return false;
        }
        HashSet<ChunkUpgrade> upgradeSet = new HashSet<ChunkUpgrade>();
        if (this.upgrades != null) {
            upgradeSet.addAll(Arrays.asList(this.upgrades));
        }
        if (changed = v ? upgradeSet.add(upgrade) : upgradeSet.remove((Object)upgrade)) {
            this.upgrades = upgradeSet.isEmpty() ? null : upgradeSet.toArray(new ChunkUpgrade[0]);
            ClaimedChunks.INSTANCE.markDirty();
        }
        return changed;
    }

    public int hashCode() {
        return this.pos.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o.getClass() == ClaimedChunk.class) {
            return this.pos.equalsChunkDimPos(((ClaimedChunk)o).pos);
        }
        return false;
    }
}

