/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.api_impl;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbu.FTBU;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.FTBUPermissions;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api.chunks.ChunkModifiedEvent;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunks;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrades;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.handlers.FTBUPlayerEventHandler;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksUpdate;
import com.feed_the_beast.ftbu.util.FTBUPlayerData;
import com.feed_the_beast.ftbu.util.FTBUTeamData;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.server.permission.PermissionAPI;

public class ClaimedChunks
implements IClaimedChunks,
ForgeChunkManager.LoadingCallback {
    public static final ClaimedChunks INSTANCE = new ClaimedChunks();
    private final Collection<ClaimedChunk> pendingChunks = new HashSet<ClaimedChunk>();
    private final Map<ChunkDimPos, ClaimedChunk> map = new HashMap<ChunkDimPos, ClaimedChunk>();
    private final Map<TicketKey, ForgeChunkManager.Ticket> ticketMap = new HashMap<TicketKey, ForgeChunkManager.Ticket>();
    private final Map<ChunkDimPos, ForgeChunkManager.Ticket> chunkTickets = new HashMap<ChunkDimPos, ForgeChunkManager.Ticket>();
    public long nextChunkloaderUpdate;
    private boolean isDirty = true;

    private ClaimedChunks() {
    }

    @Override
    public void markDirty() {
        this.isDirty = true;
    }

    public void clear() {
        this.pendingChunks.clear();
        this.map.clear();
        this.ticketMap.clear();
        this.chunkTickets.clear();
        this.nextChunkloaderUpdate = 0L;
        this.isDirty = true;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        for (ForgeChunkManager.Ticket ticket : tickets) {
            TicketKey key = new TicketKey(world.field_73011_w.getDimension(), ticket.getModData().func_74779_i("Team"));
            if (key.teamId.isEmpty()) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            ForgeChunkManager.Ticket removed = this.ticketMap.remove(key);
            if (removed == null || removed == ticket) continue;
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)removed);
        }
    }

    public void processQueue() {
        if (!this.pendingChunks.isEmpty()) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                ClaimedChunk prevChunk = this.map.put(chunk.getPos(), chunk);
                if (prevChunk != null && prevChunk != chunk) {
                    prevChunk.setInvalid();
                }
                this.markDirty();
            }
            this.pendingChunks.clear();
        }
        Iterator<ClaimedChunk> iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            ClaimedChunk chunk;
            chunk = iterator.next();
            if (!chunk.isInvalid()) continue;
            this.unforceChunk(chunk);
            iterator.remove();
        }
    }

    @Nullable
    private ForgeChunkManager.Ticket requestTicket(TicketKey key) {
        WorldServer worldServer;
        ForgeChunkManager.Ticket ticket = this.ticketMap.get(key);
        if (ticket == null && DimensionManager.isDimensionRegistered((int)key.dimension) && (ticket = ForgeChunkManager.requestTicket((Object)FTBU.INST, (World)(worldServer = ServerUtils.getServer().func_71218_a(key.dimension)), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL)) != null) {
            this.ticketMap.put(key, ticket);
            ticket.getModData().func_74778_a("Team", key.teamId);
        }
        return ticket;
    }

    private void forceChunk(ClaimedChunk chunk) {
        if (chunk.forced != null && chunk.forced.booleanValue()) {
            return;
        }
        ChunkDimPos pos = chunk.getPos();
        ForgeChunkManager.Ticket ticket = this.requestTicket(new TicketKey(pos.dim, chunk.getTeam().func_176610_l()));
        if (ticket == null) {
            return;
        }
        ChunkPos chunkPos = pos.getChunkPos();
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
        chunk.forced = true;
        this.chunkTickets.put(pos, ticket);
        if (FTBUConfig.world.log_chunkloading) {
            FTBUFinals.LOGGER.info(FTBULang.CHUNKS_CHUNKLOADER_FORCED.translate(new Object[]{chunk.getTeam().getTitle(), pos.posX, pos.posZ, ServerUtils.getDimensionName(null, (int)pos.dim)}));
        }
    }

    private void unforceChunk(ClaimedChunk chunk) {
        if (chunk.forced != null && !chunk.forced.booleanValue()) {
            return;
        }
        ChunkDimPos pos = chunk.getPos();
        ForgeChunkManager.Ticket ticket = this.chunkTickets.get(pos);
        if (ticket == null) {
            return;
        }
        ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos.getChunkPos());
        this.chunkTickets.remove(pos);
        chunk.forced = false;
        if (ticket.getChunkList().isEmpty()) {
            this.ticketMap.remove(new TicketKey(pos.dim, chunk.getTeam().func_176610_l()));
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        if (FTBUConfig.world.log_chunkloading) {
            FTBUFinals.LOGGER.info(FTBULang.CHUNKS_CHUNKLOADER_UNFORCED.translate(new Object[]{chunk.getTeam().getTitle(), pos.posX, pos.posZ, ServerUtils.getDimensionName(null, (int)pos.dim)}));
        }
    }

    private boolean canForceChunks(IForgeTeam team) {
        List members = team.getMembers();
        for (IForgePlayer player : members) {
            if (!player.isOnline()) continue;
            return true;
        }
        for (IForgePlayer player : members) {
            if (!PermissionAPI.hasPermission((GameProfile)player.getProfile(), (String)"ftbu.chunkloader.load_offline", null)) continue;
            return true;
        }
        return false;
    }

    public void update(MinecraftServer server, long now) {
        if (this.nextChunkloaderUpdate <= now) {
            this.nextChunkloaderUpdate = now + 1200L;
            this.markDirty();
        }
        if (this.isDirty) {
            this.processQueue();
            if (FTBUConfig.world.chunk_claiming && FTBUConfig.world.chunk_loading) {
                for (IForgeTeam team : FTBLibAPI.API.getUniverse().getTeams()) {
                    FTBUTeamData.get((IForgeTeam)team).canForceChunks = this.canForceChunks(team);
                }
                for (ClaimedChunk chunk : this.getAllChunks()) {
                    boolean force;
                    boolean bl = force = chunk.getData().canForceChunks && chunk.hasUpgrade(ChunkUpgrades.LOADED);
                    if (chunk.forced != null && chunk.forced == force) continue;
                    if (force) {
                        this.forceChunk(chunk);
                        continue;
                    }
                    this.unforceChunk(chunk);
                }
            }
            for (EntityPlayerMP player : ServerUtils.getPlayers()) {
                ChunkDimPos playerPos = new ChunkDimPos((Entity)player);
                int startX = playerPos.posX - 7;
                int startZ = playerPos.posZ - 7;
                new MessageClaimedChunksUpdate(startX, startZ, (EntityPlayer)player).sendTo((EntityPlayer)player);
                FTBUPlayerEventHandler.updateChunkMessage((EntityPlayer)player, playerPos);
            }
            this.isDirty = false;
        }
    }

    @Override
    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        if (!FTBUConfig.world.chunk_claiming) {
            return null;
        }
        ClaimedChunk chunk = this.map.get(pos);
        return chunk == null || chunk.isInvalid() ? null : chunk;
    }

    public void removeChunk(ChunkDimPos pos) {
        ClaimedChunk prevChunk = this.map.get(pos);
        if (prevChunk != null) {
            prevChunk.setInvalid();
            this.markDirty();
        }
    }

    public void addChunk(ClaimedChunk chunk) {
        this.pendingChunks.add(chunk);
        this.markDirty();
    }

    public Collection<ClaimedChunk> getAllChunks() {
        return !FTBUConfig.world.chunk_claiming ? Collections.emptyList() : this.getAllChunksIgnoreConfig();
    }

    public Collection<ClaimedChunk> getAllChunksIgnoreConfig() {
        return this.map.isEmpty() ? Collections.emptyList() : this.map.values();
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable IForgeTeam team, boolean includePending) {
        if (team == null) {
            return Collections.emptySet();
        }
        HashSet<ClaimedChunk> set = new HashSet<ClaimedChunk>();
        for (ClaimedChunk chunk : this.map.values()) {
            if (chunk.isInvalid() || !team.equalsTeam(chunk.getTeam())) continue;
            set.add(chunk);
        }
        if (includePending) {
            for (ClaimedChunk chunk : this.pendingChunks) {
                if (!team.equalsTeam(chunk.getTeam())) continue;
                set.add(chunk);
            }
        }
        return set;
    }

    public Set<ClaimedChunk> getTeamChunks(@Nullable IForgeTeam team) {
        return this.getTeamChunks(team, false);
    }

    @Override
    public boolean canPlayerInteract(EntityPlayerMP player, EnumHand hand, BlockPosContainer block, BlockInteractionType type) {
        if (!FTBUConfig.world.chunk_claiming) {
            return true;
        }
        if (FTBUPermissions.canModifyBlock(player, hand, block, type)) {
            return true;
        }
        ClaimedChunk chunk = this.getChunk(new ChunkDimPos(block.getPos(), player.field_71093_bK));
        return chunk == null || chunk.getTeam().hasStatus(FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player), chunk.getData().getStatusFromType(type));
    }

    @Override
    public boolean canPlayerAttackEntity(EntityPlayerMP player, Entity entity) {
        if (entity instanceof EntityPlayer) {
            if (FTBUConfig.world.safe_spawn && player.field_71093_bK == 0 && FTBUUniverseData.isInSpawn(new ChunkDimPos(entity))) {
                return false;
            }
            if (FTBUConfig.world.enable_pvp.isDefault()) {
                boolean pvp1 = FTBUPlayerData.get((IForgePlayer)FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player)).enablePVP.getBoolean();
                boolean pvp2 = FTBUPlayerData.get((IForgePlayer)FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)entity)).enablePVP.getBoolean();
                return pvp1 && pvp2;
            }
            return FTBUConfig.world.enable_pvp.isTrue();
        }
        if (!(entity instanceof IMob)) {
            ClaimedChunk chunk = this.getChunk(new ChunkDimPos(entity));
            return chunk == null || chunk.getTeam().hasStatus(FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player), chunk.getData().getAttackEntitiesStatus());
        }
        return true;
    }

    public ClaimResult claimChunk(@Nullable FTBUTeamData data, ChunkDimPos pos) {
        if (!FTBUConfig.world.allowDimension(pos.dim)) {
            return ClaimResult.DIMENSION_BLOCKED;
        }
        if (data == null) {
            return ClaimResult.NO_TEAM;
        }
        int max = data.getMaxClaimChunks();
        if (max == 0 || this.getTeamChunks(data.team, true).size() >= max) {
            return ClaimResult.NO_POWER;
        }
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk != null) {
            return ClaimResult.ALREADY_CLAIMED;
        }
        chunk = new ClaimedChunk(pos, data);
        this.addChunk(chunk);
        new ChunkModifiedEvent.Claimed(chunk).post();
        return ClaimResult.SUCCESS;
    }

    public boolean unclaimChunk(IForgeTeam team, ChunkDimPos pos) {
        ClaimedChunk chunk = this.map.get(pos);
        if (chunk != null && !chunk.isInvalid()) {
            this.setLoaded(team, pos, false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
            return true;
        }
        return false;
    }

    public void unclaimAllChunks(IForgeTeam team, @Nullable Integer dim) {
        for (ClaimedChunk chunk : this.getTeamChunks(team)) {
            ChunkDimPos pos = chunk.getPos();
            if (dim != null && dim != pos.dim) continue;
            this.setLoaded(team, pos, false);
            new ChunkModifiedEvent.Unclaimed(chunk).post();
            this.removeChunk(pos);
        }
    }

    public boolean setLoaded(IForgeTeam team, ChunkDimPos pos, boolean loaded) {
        ClaimedChunk chunk = this.getChunk(pos);
        if (chunk == null || loaded == chunk.hasUpgrade(ChunkUpgrades.LOADED) || !chunk.getTeam().equalsTeam(team)) {
            return false;
        }
        if (loaded) {
            if (!FTBUConfig.world.allowDimension(pos.dim)) {
                return false;
            }
            int max = FTBUTeamData.get(team).getMaxChunkloaderChunks();
            if (max == 0) {
                return false;
            }
            int loadedChunks = 0;
            for (ClaimedChunk c : this.getTeamChunks(team)) {
                if (!c.hasUpgrade(ChunkUpgrades.LOADED) || ++loadedChunks < max) continue;
                return false;
            }
        } else {
            new ChunkModifiedEvent.Unloaded(chunk).post();
        }
        chunk.setHasUpgrade(ChunkUpgrades.LOADED, loaded);
        if (loaded) {
            new ChunkModifiedEvent.Loaded(chunk).post();
        }
        this.markDirty();
        return true;
    }

    public static final class TicketKey {
        public final int dimension;
        public final String teamId;

        public TicketKey(int dim, String team) {
            this.dimension = dim;
            this.teamId = team;
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.teamId);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o.getClass() == TicketKey.class) {
                TicketKey key = (TicketKey)o;
                return this.dimension == key.dimension && this.teamId.equals(key.teamId);
            }
            return false;
        }
    }

    public static enum ClaimResult {
        SUCCESS,
        NO_TEAM,
        DIMENSION_BLOCKED,
        NO_POWER,
        ALREADY_CLAIMED;

    }
}

