/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.cmd.CmdTreeBase;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.misc.BroadcastSender;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.util.backups.Backups;
import java.io.File;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;

public class CmdBackup
extends CmdTreeBase {
    public CmdBackup() {
        super("backup");
        this.addSubcommand((ICommand)new CmdStart());
        this.addSubcommand((ICommand)new CmdStop());
        this.addSubcommand((ICommand)new CmdGetSize());
    }

    public static class CmdGetSize
    extends CmdBase {
        public CmdGetSize() {
            super("getsize", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String sizeW = FileUtils.getSizeS((File)sender.func_130014_f_().func_72860_G().func_75765_b());
            String sizeT = FileUtils.getSizeS((File)Backups.INSTANCE.backupsFolder);
            FTBULang.BACKUP_SIZE.sendMessage(sender, new Object[]{sizeW, sizeT});
        }
    }

    public static class CmdStop
    extends CmdBase {
        public CmdStop() {
            super("stop", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (Backups.INSTANCE.thread != null) {
                Backups.INSTANCE.thread.interrupt();
                Backups.INSTANCE.thread = null;
                FTBULang.BACKUP_STOP.sendMessage(sender, new Object[0]);
                return;
            }
            throw FTBULang.BACKUP_NOT_RUNNING.commandError(new Object[0]);
        }
    }

    public static class CmdStart
    extends CmdBase {
        public CmdStart() {
            super("start", CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            boolean b = Backups.INSTANCE.run(server, sender, args.length == 0 ? "" : args[0]);
            if (b) {
                FTBULang.BACKUP_MANUAL_LAUNCH.sendMessage((ICommandSender)BroadcastSender.INSTANCE, new Object[]{sender.func_70005_c_()});
                if (!FTBUConfig.backups.use_separate_thread) {
                    Backups.INSTANCE.postBackup();
                }
            } else {
                FTBULang.BACKUP_ALREADY_RUNNING.sendMessage(sender, new Object[0]);
            }
        }
    }
}

