/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.cmd.CmdTreeBase;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbu.net.MessageEditNBT;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class CmdEditNBT
extends CmdTreeBase {
    public static Map<UUID, NBTTagCompound> EDITING = new HashMap<UUID, NBTTagCompound>();

    public CmdEditNBT() {
        super("nbtedit");
        this.addSubcommand((ICommand)new CmdTile());
        this.addSubcommand((ICommand)new CmdEntity());
        this.addSubcommand((ICommand)new CmdPlayer());
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        RayTraceResult ray;
        if (args.length == 0 && (ray = MathUtils.rayTrace((EntityPlayer)CmdEditNBT.func_71521_c((ICommandSender)sender), (boolean)false)) != null) {
            switch (ray.field_72313_a) {
                case BLOCK: {
                    ((ICommand)this.getCommandMap().get("tile")).func_184881_a(server, sender, new String[]{Integer.toString(ray.func_178782_a().func_177958_n()), Integer.toString(ray.func_178782_a().func_177956_o()), Integer.toString(ray.func_178782_a().func_177952_p())});
                    return;
                }
                case ENTITY: {
                    ((ICommand)this.getCommandMap().get("entity")).func_184881_a(server, sender, new String[]{Integer.toString(ray.field_72308_g.func_145782_y())});
                    return;
                }
            }
        }
        if (args.length == 1 && args[0].equals("me")) {
            ((ICommand)this.getCommandMap().get("player")).func_184881_a(server, sender, new String[]{CmdEditNBT.func_71521_c((ICommandSender)sender).func_70005_c_()});
            return;
        }
        super.func_184881_a(server, sender, args);
    }

    private static class CmdPlayer
    extends CmdNBT {
        private CmdPlayer() {
            super("player");
        }

        public boolean func_82358_a(String[] args, int i) {
            return i == 0;
        }

        @Override
        public void editNBT(EntityPlayerMP player, NBTTagCompound info, NBTTagCompound nbt, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 1);
            EntityPlayerMP player1 = CmdPlayer.func_184888_a((MinecraftServer)player.field_71133_b, (ICommandSender)player, (String)args[0]);
            info.func_74778_a("type", "player");
            info.func_186854_a("id", player1.func_146103_bH().getId());
            player1.func_189511_e(nbt);
        }
    }

    private static class CmdEntity
    extends CmdNBT {
        private CmdEntity() {
            super("entity");
        }

        @Override
        public void editNBT(EntityPlayerMP player, NBTTagCompound info, NBTTagCompound nbt, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 1);
            int id = CmdEntity.func_175755_a((String)args[0]);
            Entity entity = player.func_130014_f_().func_73045_a(id);
            if (entity != null) {
                info.func_74778_a("type", "entity");
                info.func_74768_a("id", id);
                entity.func_189511_e(nbt);
            }
        }
    }

    private static class CmdTile
    extends CmdNBT {
        private CmdTile() {
            super("tile");
        }

        @Override
        public void editNBT(EntityPlayerMP player, NBTTagCompound info, NBTTagCompound nbt, String[] args) throws CommandException {
            this.checkArgs((ICommandSender)player, args, 3);
            int x = CmdTile.func_175755_a((String)args[0]);
            int y = CmdTile.func_175755_a((String)args[1]);
            int z = CmdTile.func_175755_a((String)args[2]);
            TileEntity tile = player.func_130014_f_().func_175625_s(new BlockPos(x, y, z));
            if (tile != null) {
                info.func_74778_a("type", "tile");
                info.func_74768_a("x", x);
                info.func_74768_a("y", y);
                info.func_74768_a("z", z);
                tile.func_189515_b(nbt);
                nbt.func_82580_o("x");
                nbt.func_82580_o("y");
                nbt.func_82580_o("z");
                info.func_74778_a("id", nbt.func_74779_i("id"));
                nbt.func_82580_o("id");
            }
        }
    }

    public static class CmdNBT
    extends CmdBase {
        private CmdNBT(String id) {
            super(id, CmdBase.Level.OP);
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player = CmdNBT.func_71521_c((ICommandSender)sender);
            NBTTagCompound info = new NBTTagCompound();
            NBTTagCompound nbt = new NBTTagCompound();
            this.editNBT(player, info, nbt, args);
            if (info.func_74764_b("type")) {
                info.func_74772_a("random", MathUtils.RAND.nextLong());
                EDITING.put(player.func_146103_bH().getId(), info);
                new MessageEditNBT(info, nbt).sendTo((EntityPlayer)player);
            }
        }

        public void editNBT(EntityPlayerMP player, NBTTagCompound info, NBTTagCompound nbt, String[] args) throws CommandException {
        }
    }
}

