/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.io.RequestMethod;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.net.MessageViewCrash;
import com.feed_the_beast.ftbu.net.MessageViewCrashList;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class CmdViewCrash
extends CmdBase {
    public CmdViewCrash() {
        super("view_crash", CmdBase.Level.OP);
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return !server.func_71262_S() || super.func_184882_a(server, sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        String[] files;
        File folder;
        if (args.length == 1 && (folder = new File(CommonUtils.folderMinecraft, "crash-reports")).exists() && folder.isDirectory() && (files = folder.list()) != null && files.length > 0) {
            if (files.length > 1) {
                Arrays.sort(files, StringUtils.IGNORE_CASE_COMPARATOR.reversed());
            }
            return CmdViewCrash.func_71530_a((String[])args, (String[])files);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = CmdViewCrash.func_71521_c((ICommandSender)sender);
        if (args.length == 0) {
            new MessageViewCrashList(new File(CommonUtils.folderMinecraft, "crash-reports")).sendTo((EntityPlayer)player);
        } else {
            this.checkArgs(sender, args, 1);
            File file = new File(CommonUtils.folderMinecraft, "crash-reports/" + (args[0].endsWith(".txt") ? args[0] : "crash-" + args[0] + ".txt"));
            if (file.exists()) {
                if (args.length >= 2 && args[1].equals("upload")) {
                    new ThreadUploadCrash(file, sender).start();
                    return;
                }
                try {
                    new MessageViewCrash(file.getName(), StringUtils.readStringList((Reader)new FileReader(file))).sendTo((EntityPlayer)player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class ThreadUploadCrash
    extends Thread {
        private final File file;
        private final ICommandSender sender;

        public ThreadUploadCrash(File f, ICommandSender s) {
            this.file = f;
            this.sender = s;
        }

        @Override
        public void run() {
            try {
                File urlFile = new File(CommonUtils.folderLocal, "ftbutilities/uploaded_crash_reports/" + this.file.getName());
                String url = "";
                if (urlFile.exists()) {
                    url = FileUtils.loadAsText((File)urlFile);
                } else {
                    List text = StringUtils.readStringList((InputStream)new FileInputStream(this.file));
                    HttpURLConnection con = (HttpURLConnection)new URL("https://hastebin.com/documents").openConnection();
                    con.setRequestMethod(RequestMethod.POST.name());
                    con.setRequestProperty("User-Agent", "HTTP/1.1");
                    con.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
                    con.setDoOutput(true);
                    con.setDoInput(true);
                    OutputStreamWriter writer = new OutputStreamWriter(con.getOutputStream(), StandardCharsets.UTF_8);
                    for (String s : text) {
                        writer.write(s);
                        writer.write(10);
                    }
                    writer.close();
                    con.getResponseCode();
                    JsonElement response = JsonUtils.fromJson((Reader)new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));
                    if (response.isJsonObject() && response.getAsJsonObject().has("key")) {
                        url = "https://hastebin.com/" + response.getAsJsonObject().get("key").getAsString() + ".md";
                        FileUtils.save((File)urlFile, (String)url);
                    }
                }
                if (!url.isEmpty()) {
                    ITextComponent link = FTBLibLang.CLICK_HERE.textComponent(this.sender);
                    link.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(url)));
                    link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
                    FTBULang.UPLOADED_CRASH.sendMessage(this.sender, new Object[]{link});
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

