/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd.chunks;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.cmd.CmdBase;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.FTBUNotifications;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.cmd.chunks.CmdChunks;
import com.feed_the_beast.ftbu.util.FTBUTeamData;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.server.command.TextComponentHelper;
import net.minecraftforge.server.permission.PermissionAPI;

public class CmdClaim
extends CmdBase {
    public CmdClaim() {
        super("claim", CmdBase.Level.ALL);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IForgePlayer p;
        if (!FTBUConfig.world.chunk_claiming) {
            throw FTBLibLang.FEATURE_DISABLED.commandError(new Object[0]);
        }
        EntityPlayerMP player = CmdClaim.func_71521_c((ICommandSender)sender);
        if (args.length >= 1) {
            if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbu.claims.modify.others")) {
                throw FTBLibLang.COMMAND_PERMISSION.commandError(new Object[0]);
            }
            p = CmdClaim.getForgePlayer((String)args[0]);
        } else {
            p = CmdClaim.getForgePlayer((ICommandSender)player);
        }
        if (p.getTeam() == null) {
            throw FTBLibLang.TEAM_NO_TEAM.commandError(new Object[0]);
        }
        ChunkDimPos pos = new ChunkDimPos((Entity)player);
        if (!FTBUConfig.world.allowDimension(pos.dim)) {
            Notification.of((ResourceLocation)FTBUFinals.get("cant_claim_chunk"), (ITextComponent[])new ITextComponent[]{TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"ftbu.lang.chunks.claiming_not_enabled_dim", (Object[])new Object[0])}).setError().send((EntityPlayer)player);
            return;
        }
        switch (ClaimedChunks.INSTANCE.claimChunk(FTBUTeamData.get(p.getTeam()), pos)) {
            case SUCCESS: {
                Notification.of((ResourceLocation)FTBUFinals.get("chunk_modified"), (ITextComponent[])new ITextComponent[]{TextComponentHelper.createComponentTranslation((ICommandSender)player, (String)"ftbu.lang.chunks.chunk_claimed", (Object[])new Object[0])}).send((EntityPlayer)player);
                CmdChunks.updateChunk(player, pos);
                break;
            }
            case DIMENSION_BLOCKED: {
                break;
            }
            case NO_POWER: {
                break;
            }
            case ALREADY_CLAIMED: {
                FTBUNotifications.sendCantModifyChunk(player);
            }
        }
    }
}

