/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class ClientClaimedChunks {

    public static class ChunkData {
        public static final DataOut.Serializer<ChunkUpgrade> UPGRADE_SERIALIZER = (data, upgrade) -> data.writeString(upgrade.func_176610_l());
        public static final DataIn.Deserializer<ChunkUpgrade> UPGRADE_DESERIALIZER = data -> FTBUUniverseData.CHUNK_UPGRADES.get(data.readString());
        public static final DataOut.Serializer<ChunkData> SERIALIZER = (data, d) -> data.writeCollection(d.upgrades, UPGRADE_SERIALIZER);
        public static final DataIn.Deserializer<ChunkData> DESERIALIZER = data -> {
            ChunkData d = new ChunkData(Team.currentTeam);
            data.readCollection(d.upgrades, UPGRADE_DESERIALIZER);
            return d;
        };
        public final Team team;
        public final Collection<ChunkUpgrade> upgrades = new HashSet<ChunkUpgrade>();

        public ChunkData(Team t) {
            this.team = t;
        }

        public boolean hasUpgrade(ChunkUpgrade upgrade) {
            return this.upgrades.contains((Object)upgrade);
        }

        public void setHasUpgrade(ChunkUpgrade upgrade, boolean val) {
            if (val) {
                this.upgrades.add(upgrade);
            } else {
                this.upgrades.remove((Object)upgrade);
            }
        }

        public int hashCode() {
            return Objects.hash(this.team, this.upgrades);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o != null && o.getClass() == ChunkData.class) {
                ChunkData d = (ChunkData)o;
                return this.team.equals(d.team) && this.upgrades.equals(d.upgrades);
            }
            return false;
        }
    }

    public static class Team {
        private static Team currentTeam;
        public static final DataOut.Serializer<Team> SERIALIZER;
        public static final DataIn.Deserializer<Team> DESERIALIZER;
        public final UUID ownerId;
        public EnumTeamColor color;
        public String formattedName;
        public boolean isAlly;
        public final Map<Integer, ChunkData> chunks = new Int2ObjectOpenHashMap();

        public Team(UUID id) {
            this.ownerId = id;
        }

        static {
            SERIALIZER = (data, team) -> {
                data.writeUUID(team.ownerId);
                data.writeString(team.formattedName);
                data.write((DataOut.Serializer)EnumTeamColor.NAME_MAP, (Object)team.color);
                data.writeBoolean(team.isAlly);
                data.writeMap(team.chunks, DataOut.INT, ChunkData.SERIALIZER);
            };
            DESERIALIZER = data -> {
                Team team = new Team(data.readUUID());
                team.formattedName = data.readString();
                team.color = (EnumTeamColor)data.read((DataIn.Deserializer)EnumTeamColor.NAME_MAP);
                team.isAlly = data.readBoolean();
                currentTeam = team;
                data.readMap(team.chunks, DataIn.INT, ChunkData.DESERIALIZER);
                return team;
            };
        }
    }
}

