/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.misc.ChunkSelectorMap;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiChunkSelectorBase;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrades;
import com.feed_the_beast.ftbu.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbu.gui.UpdateClientDataEvent;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksModify;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksUpdate;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@EventHandler(value={Side.CLIENT})
public class GuiClaimedChunks
extends GuiChunkSelectorBase {
    public static GuiClaimedChunks instance;
    private static final ClientClaimedChunks.ChunkData[] chunkData;
    private static int claimedChunks;
    private static int loadedChunks;
    private static int maxClaimedChunks;
    private static int maxLoadedChunks;
    private static final ClientClaimedChunks.ChunkData NULL_CHUNK_DATA;
    private static final CachedVertexData AREA;
    private final String currentDimName;
    private final Button buttonRefresh;
    private final Button buttonClose;
    private final Button buttonUnclaimDim;
    private final Button buttonUnclaimAll;
    private final Button buttonInfo;

    @Nullable
    private static ClientClaimedChunks.ChunkData getAt(int x, int y) {
        int i = x + y * 15;
        return i < 0 || i >= chunkData.length ? null : chunkData[i];
    }

    private static boolean hasBorder(ClientClaimedChunks.ChunkData data, @Nullable ClientClaimedChunks.ChunkData with) {
        if (with == null) {
            with = NULL_CHUNK_DATA;
        }
        return (!data.upgrades.equals(with.upgrades) || data.team != with.team) && !with.hasUpgrade(ChunkUpgrades.LOADED);
    }

    @SubscribeEvent
    public static void onChunkDataUpdate(UpdateClientDataEvent event) {
        ClientClaimedChunks.ChunkData data;
        MessageClaimedChunksUpdate m = event.getMessage();
        claimedChunks = m.claimedChunks;
        loadedChunks = m.loadedChunks;
        maxClaimedChunks = m.maxClaimedChunks;
        maxLoadedChunks = m.maxLoadedChunks;
        Arrays.fill(chunkData, null);
        for (ClientClaimedChunks.Team team : m.teams.values()) {
            for (Map.Entry<Integer, ClientClaimedChunks.ChunkData> entry : team.chunks.entrySet()) {
                int x = entry.getKey() % 15;
                int z = entry.getKey() / 15;
                GuiClaimedChunks.chunkData[x + z * 15] = entry.getValue();
            }
        }
        AREA.reset();
        EnumTeamColor prevCol = null;
        for (int i = 0; i < chunkData.length; ++i) {
            data = chunkData[i];
            if (data == null) continue;
            if (prevCol != data.team.color) {
                prevCol = data.team.color;
                GuiClaimedChunks.AREA.color.set(data.team.color.getColor(), 150);
            }
            AREA.rect(i % 15 * 12, i / 15 * 12, 12, 12);
        }
        for (int i = 0; i < chunkData.length; ++i) {
            boolean borderR;
            data = chunkData[i];
            if (data == null) continue;
            int x = i % 15;
            int dx = x * 12;
            int y = i / 15;
            int dy = y * 12;
            boolean borderU = y > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y - 1));
            boolean borderD = y < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x, y + 1));
            boolean borderL = x > 0 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x - 1, y));
            boolean bl = borderR = x < 14 && GuiClaimedChunks.hasBorder(data, GuiClaimedChunks.getAt(x + 1, y));
            if (data.hasUpgrade(ChunkUpgrades.LOADED)) {
                GuiClaimedChunks.AREA.color.set(255, 80, 80, 230);
            } else {
                GuiClaimedChunks.AREA.color.set(80, 80, 80, 230);
            }
            if (borderU) {
                AREA.rect(dx, dy, 12, 1);
            }
            if (borderD) {
                AREA.rect(dx, dy + 12 - 1, 12, 1);
            }
            if (borderL) {
                AREA.rect(dx, dy, 1, 12);
            }
            if (!borderR) continue;
            AREA.rect(dx + 12 - 1, dy, 1, 12);
        }
    }

    public GuiClaimedChunks() {
        this.currentDimName = ServerUtils.getDimensionName(null, (int)ClientUtils.MC.field_71441_e.field_73011_w.getDimension()).func_150254_d();
        this.buttonClose = new ButtonSide((GuiBase)this, GuiLang.CLOSE.translate(), GuiIcons.ACCEPT){

            public void onClicked(MouseButton button) {
                this.gui.closeGui();
            }
        };
        this.buttonRefresh = new ButtonSide((GuiBase)this, GuiLang.REFRESH.translate(), GuiIcons.REFRESH){

            public void onClicked(MouseButton button) {
                new MessageClaimedChunksRequest(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ).sendToServer();
                ChunkSelectorMap.getMap().resetMap(GuiClaimedChunks.this.startX, GuiClaimedChunks.this.startZ);
            }
        };
        this.buttonUnclaimDim = new ButtonSide((GuiBase)this, FTBULang.CHUNKS_UNCLAIM_ALL_DIM.translate(new Object[]{this.currentDimName}), GuiIcons.REMOVE){

            public void onClicked(MouseButton button) {
                String s = FTBULang.CHUNKS_UNCLAIM_ALL_DIM_Q.translate(new Object[]{GuiClaimedChunks.this.currentDimName});
                ClientUtils.MC.func_147108_a((GuiScreen)new GuiYesNo((set, id) -> {
                    if (set) {
                        ClientUtils.execClientCommand((String)"/ftb chunks unclaim_all false");
                    }
                    this.gui.openGui();
                    this.gui.refreshWidgets();
                }, s, "", 0));
            }
        };
        this.buttonUnclaimAll = new ButtonSide((GuiBase)this, FTBULang.CHUNKS_UNCLAIM_ALL.translate(), GuiIcons.REMOVE){

            public void onClicked(MouseButton button) {
                String s = FTBULang.CHUNKS_UNCLAIM_ALL_Q.translate();
                ClientUtils.MC.func_147108_a((GuiScreen)new GuiYesNo((set, id) -> {
                    if (set) {
                        ClientUtils.execClientCommand((String)"/ftb chunks unclaim_all true");
                    }
                    this.gui.openGui();
                    this.gui.refreshWidgets();
                }, s, "", 1));
            }
        };
        this.buttonInfo = new ButtonSide((GuiBase)this, GuiLang.INFO.translate(), GuiIcons.INFO){

            public void onClicked(MouseButton button) {
                ClientUtils.execClientCommand((String)"/ftbc open_guide ftbu.chunk_claiming");
            }
        };
    }

    public void onInit() {
        this.buttonRefresh.onClicked(MouseButton.LEFT);
    }

    public int getSelectionMode(MouseButton button) {
        boolean claim = !GuiScreen.func_146272_n();
        boolean flag = button.isLeft();
        if (flag) {
            return claim ? 0 : 2;
        }
        return claim ? 1 : 3;
    }

    public void onChunksSelected(Collection<ChunkPos> chunks) {
        new MessageClaimedChunksModify(this.startX, this.startZ, this.currentSelectionMode, chunks).sendToServer();
    }

    public void drawArea(Tessellator tessellator, BufferBuilder buffer) {
        AREA.draw(tessellator, buffer);
    }

    public void addCornerButtons(Panel panel) {
        panel.add((Widget)this.buttonClose);
        panel.add((Widget)this.buttonRefresh);
        panel.addAll(new Widget[]{this.buttonUnclaimDim});
        panel.add((Widget)this.buttonUnclaimAll);
        panel.addAll(new Widget[]{this.buttonInfo});
    }

    public void addCornerText(List<String> list, GuiChunkSelectorBase.Corner corner) {
        switch (corner) {
            case TOP_LEFT: {
                list.add(StringUtils.translate((String)"guide.ftbu.chunk_claiming.list.left_click"));
                list.add(StringUtils.translate((String)"guide.ftbu.chunk_claiming.list.right_click"));
                break;
            }
            case BOTTOM_LEFT: {
                list.add(StringUtils.translate((String)"guide.ftbu.chunk_claiming.list.shift_left_click"));
                list.add(StringUtils.translate((String)"guide.ftbu.chunk_claiming.list.shift_right_click"));
                break;
            }
            case BOTTOM_RIGHT: {
                list.add(FTBULang.CHUNKS_CLAIMED_COUNT.translate(new Object[]{claimedChunks, maxClaimedChunks}));
                list.add(FTBULang.CHUNKS_LOADED_COUNT.translate(new Object[]{loadedChunks, maxLoadedChunks}));
            }
        }
    }

    public void addButtonText(GuiChunkSelectorBase.MapButton button, List<String> list) {
        ClientClaimedChunks.ChunkData data = chunkData[button.index];
        if (data != null) {
            list.add(data.team.formattedName);
            list.add(TextFormatting.GREEN + FTBULang.CHUNKS_CLAIMED_AREA.translate());
            for (ChunkUpgrade upgrade : FTBUUniverseData.CHUNK_UPGRADES.values()) {
                if (upgrade.isInternal() || !data.hasUpgrade(upgrade)) continue;
                list.add(TextFormatting.RED + upgrade.getLangKey().translate());
            }
        } else {
            list.add(TextFormatting.DARK_GREEN + FTBULang.CHUNKS_WILDERNESS.translate());
        }
        if (GuiScreen.func_146271_m()) {
            list.add(button.chunkPos.toString());
        }
    }

    static {
        chunkData = new ClientClaimedChunks.ChunkData[225];
        NULL_CHUNK_DATA = new ClientClaimedChunks.ChunkData(new ClientClaimedChunks.Team(UUID.randomUUID()));
        AREA = new CachedVertexData(7, DefaultVertexFormats.field_181706_f);
    }

    private static abstract class ButtonSide
    extends Button {
        public ButtonSide(GuiBase gui, String text, Icon icon) {
            super(gui, 0, 0, 20, 20, text, icon);
        }

        public Icon getIcon() {
            return this.getButtonBackground().combineWith(this.icon.withBorder(2));
        }
    }
}

