/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.LeaderboardValue;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiLeaderboard
extends GuiBase {
    private final Panel panelButtons;
    private final PanelScrollBar scrollBar;
    private final String title;
    private final List<LeaderboardValue> leaderboard;
    private int rankSize;
    private int usernameSize;
    private int valueSize;

    public GuiLeaderboard(ITextComponent c, List<LeaderboardValue> l) {
        super(0, 0);
        this.leaderboard = l;
        this.title = FTBULang.LEADERBOARDS.translate() + " > " + c.func_150254_d();
        this.panelButtons = new Panel(this.gui, 9, 9, 0, 146){

            public void addWidgets() {
                this.width = 0;
                int i = 0;
                GuiLeaderboard.this.rankSize = 0;
                GuiLeaderboard.this.usernameSize = 0;
                GuiLeaderboard.this.valueSize = 0;
                for (LeaderboardValue value : GuiLeaderboard.this.leaderboard) {
                    value.rank = ++i;
                    this.add(new LeaderboardEntry(this.gui, value));
                }
                for (Widget w : this.widgets) {
                    this.setWidth(Math.max(this.width, w.width));
                }
                for (Widget w : this.widgets) {
                    w.setWidth(this.width);
                }
                this.updateWidgetPositions();
            }

            public void updateWidgetPositions() {
                int size = this.align(WidgetLayout.VERTICAL);
                GuiLeaderboard.this.scrollBar.setElementSize(size);
                GuiLeaderboard.this.scrollBar.setSrollStepFromOneElementSize(14);
                this.setHeight(this.widgets.size() > 10 ? 144 : size);
                this.gui.setHeight(this.height + 18);
            }

            public Icon getIcon() {
                return this.gui.getTheme().getPanelBackground();
            }
        };
        this.panelButtons.addFlags(3);
        this.scrollBar = new PanelScrollBar(this, 0, 8, 16, 146, 0, this.panelButtons){

            public boolean shouldRender() {
                return true;
            }

            public boolean canMouseScroll() {
                return true;
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.panelButtons);
        if (this.panelButtons.widgets.size() > 10) {
            this.add((Widget)this.scrollBar);
        }
        this.scrollBar.setX(this.panelButtons.posX + this.panelButtons.width + 6);
        this.setWidth(this.scrollBar.posX + (this.panelButtons.widgets.size() > 10 ? this.scrollBar.width + 8 : 4));
        this.posX = (this.getScreen().func_78326_a() - this.width) / 2;
    }

    public void drawBackground() {
        this.drawString(this.title, this.getAX() + (this.width - this.gui.getStringWidth(this.title)) / 2, this.getAY() - this.getFontHeight() - 2, 2);
    }

    private class LeaderboardEntry
    extends Widget {
        private final LeaderboardValue value;
        private final String rank;

        public LeaderboardEntry(GuiBase g, LeaderboardValue v) {
            super(g, 0, 0, 0, 14);
            this.value = v;
            this.rank = this.value.color + "#" + StringUtils.add0s((int)v.rank, (int)GuiLeaderboard.this.leaderboard.size());
            GuiLeaderboard.this.rankSize = Math.max(GuiLeaderboard.this.rankSize, this.gui.getStringWidth(this.rank) + 4);
            GuiLeaderboard.this.usernameSize = Math.max(GuiLeaderboard.this.usernameSize, this.gui.getStringWidth(v.username) + 8);
            GuiLeaderboard.this.valueSize = Math.max(GuiLeaderboard.this.valueSize, this.gui.getStringWidth(this.value.value.func_150254_d()) + 8);
            this.setWidth(GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize);
        }

        public void addMouseOverText(List<String> list) {
        }

        public void renderWidget() {
            int ax = this.getAX();
            int ay = this.getAY();
            Icon widget = this.value.color == TextFormatting.DARK_GRAY ? this.gui.getTheme().getDisabledButton() : this.gui.getTheme().getButton(this.gui.isMouseOver((Widget)this));
            int textY = ay + (this.height - this.gui.getFontHeight() + 1) / 2;
            widget.draw(ax, ay, GuiLeaderboard.this.rankSize, this.height);
            this.gui.drawString(this.rank, ax + 2, textY, 2);
            widget.draw(ax + GuiLeaderboard.this.rankSize, ay, GuiLeaderboard.this.usernameSize, this.height);
            this.gui.drawString(this.value.color + this.value.username, ax + 4 + GuiLeaderboard.this.rankSize, textY, 2);
            widget.draw(ax + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize, ay, GuiLeaderboard.this.valueSize, this.height);
            String formattedText = this.value.value.func_150254_d();
            this.gui.drawString(this.value.color + formattedText, ax + GuiLeaderboard.this.rankSize + GuiLeaderboard.this.usernameSize + GuiLeaderboard.this.valueSize - this.gui.getStringWidth(formattedText) - 4, textY, 2);
        }
    }
}

