/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui;

import com.feed_the_beast.ftbl.lib.client.CachedVertexData;
import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.LoadingIcon;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbu.net.MessageSendWarpList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;

public class GuiWarps
extends GuiBase {
    public static GuiWarps INSTANCE = null;
    private static final int SIZE = 220;
    private static final int SIZE_2 = 110;
    private static final int SIZE_I = 27;
    private static final int SIZE_C = 66;
    private static final CachedVertexData BACKGROUND = new CachedVertexData(6, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CIRCLE_IN = new CachedVertexData(3, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CIRCLE_OUT = new CachedVertexData(3, DefaultVertexFormats.field_181706_f);
    private static final CachedVertexData CENTER = new CachedVertexData(6, DefaultVertexFormats.field_181706_f);
    private final ArcButton buttonCancel = new ArcButton(this, MessageSendWarpList.WarpItem.CANCEL, -1);
    private boolean isLoaded = false;
    private List<ArcButton> buttonsIn;
    private List<ArcButton> buttonsOut;
    private ArcButton buttonOver = null;
    private CachedVertexData lines;

    public boolean isMouseOver(Widget w) {
        return w instanceof ArcButton ? w == this.buttonOver : super.isMouseOver(w);
    }

    public GuiWarps() {
        super(220, 220);
    }

    public void addWidgets() {
        if (this.isLoaded) {
            this.addAll(this.buttonsIn);
            this.addAll(this.buttonsOut);
            this.add((Widget)this.buttonCancel);
        }
    }

    public void drawBackground() {
        int ax = this.getAX() + 110;
        int ay = this.getAY() + 110;
        if (!this.isLoaded) {
            LoadingIcon.INSTANCE.draw(ax - 110, ay - 110, 220, 220, Color4I.WHITE);
            return;
        }
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179129_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_178969_c((double)ax, (double)ay, 0.0);
        BACKGROUND.draw(tessellator, buffer);
        CIRCLE_IN.draw(tessellator, buffer);
        CIRCLE_OUT.draw(tessellator, buffer);
        CENTER.draw(tessellator, buffer);
        if (this.isLoaded) {
            this.lines.draw(tessellator, buffer);
        }
        this.buttonOver = this.buttonCancel;
        double dist = MathUtils.dist((double)ax, (double)ay, (double)this.getMouseX(), (double)this.getMouseY());
        double rotation = Math.atan2(this.getMouseY() - ay, this.getMouseX() - ax) * 57.29577951308232;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        buffer.func_178969_c(0.0, 0.0, 0.0);
        if (this.isLoaded) {
            if (dist < 27.0 || dist > 110.0) {
                this.drawString(TextFormatting.BOLD + GuiLang.CANCEL.translate(), ax, ay, 5);
            } else {
                this.buttonOver = dist < 66.0 ? this.buttonsIn.get((int)(rotation / (360.0 / (double)this.buttonsIn.size())) % this.buttonsIn.size()) : this.buttonsOut.get((int)(rotation / (360.0 / (double)this.buttonsOut.size())) % this.buttonsOut.size());
            }
            if (this.buttonOver.warpItem.isSpecial()) {
                this.drawString(TextFormatting.BOLD + ((ArcButton)this.buttonOver).warpItem.name, ax, ay, 5);
            } else {
                this.drawString(TextFormatting.BOLD + (this.buttonOver.warpItem.innerCircle() ? "Home" : "Warp"), ax, ay - 5, 5);
                this.drawString(((ArcButton)this.buttonOver).warpItem.name, ax, ay + 5, 5);
            }
        }
    }

    public void setData(List<MessageSendWarpList.WarpItem> list) {
        double sin;
        this.buttonsIn = new ArrayList<ArcButton>();
        this.buttonsOut = new ArrayList<ArcButton>();
        for (MessageSendWarpList.WarpItem w : list) {
            List<ArcButton> l = w.innerCircle() ? this.buttonsIn : this.buttonsOut;
            l.add(new ArcButton(this, w, l.size()));
        }
        this.lines = new CachedVertexData(1, DefaultVertexFormats.field_181706_f);
        if (this.buttonsOut.size() > 1) {
            int add = 360 / this.buttonsOut.size();
            for (int i = 0; i < 360; i += add) {
                double cos = Math.cos((double)i * (Math.PI / 180));
                sin = Math.sin((double)i * (Math.PI / 180));
                this.lines.pos(cos * 66.0, sin * 66.0, 0.0).color(102, 102, 102, 255);
                this.lines.pos(cos * 110.0, sin * 110.0, 0.0).color(102, 102, 102, 255);
            }
        }
        if (this.buttonsIn.size() > 1) {
            int add = 360 / this.buttonsIn.size();
            for (int i = 0; i < 360; i += add) {
                double cos = Math.cos((double)i * (Math.PI / 180));
                sin = Math.sin((double)i * (Math.PI / 180));
                this.lines.pos(cos * 27.0, sin * 27.0, 0.0).color(102, 102, 102, 255);
                this.lines.pos(cos * 66.0, sin * 66.0, 0.0).color(102, 102, 102, 255);
            }
        }
        this.isLoaded = true;
        this.refreshWidgets();
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public Icon getIcon() {
        return Icon.EMPTY;
    }

    static {
        BACKGROUND.pos(0.0, 0.0).color(170, 170, 170, 153);
        CENTER.pos(0.0, 0.0).color(102, 102, 102, 255);
        for (int i = 0; i <= 360; i += 6) {
            double cos = Math.cos((double)i * (Math.PI / 180));
            double sin = Math.sin((double)i * (Math.PI / 180));
            BACKGROUND.pos(cos * 110.0, sin * 110.0).color(200, 200, 200, 153);
            CIRCLE_OUT.pos(cos * 110.0, sin * 110.0).color(102, 102, 102, 255);
            CIRCLE_IN.pos(cos * 66.0, sin * 66.0).color(102, 102, 102, 255);
            CENTER.pos(cos * 27.0, sin * 27.0).color(102, 102, 102, 255);
        }
    }

    private class ArcButton
    extends Button {
        private final MessageSendWarpList.WarpItem warpItem;
        private final int index;
        private int textX;
        private int textY;

        public ArcButton(GuiBase gui, MessageSendWarpList.WarpItem w, int i) {
            super(gui, 0, 0, 0, 0);
            this.textX = -1;
            this.textY = -1;
            this.setTitle(w.cmd);
            this.warpItem = w;
            this.index = i;
        }

        public boolean collidesWith(int x, int y, int w, int h) {
            return true;
        }

        public void renderWidget() {
            if (this.index == -1) {
                return;
            }
            if (this.textX == -1) {
                boolean in = this.warpItem.innerCircle();
                double s = (in ? GuiWarps.this.buttonsIn : GuiWarps.this.buttonsOut).size();
                double i = s > 1.0 ? (double)this.index * (360.0 / s) + 180.0 / s : 270.0;
                double d = (double)(in ? 93 : 176) / 2.0;
                this.textX = (int)(Math.cos(i * (Math.PI / 180)) * d);
                this.textY = (int)(Math.sin(i * (Math.PI / 180)) * d) - 2;
            }
            this.gui.drawString(this.warpItem.name, this.gui.posX + this.gui.width / 2 + this.textX, this.gui.posY + this.gui.height / 2 + this.textY, 5);
        }

        public void onClicked(MouseButton button) {
            if (!this.warpItem.cmd.isEmpty()) {
                ClientUtils.execClientCommand((String)this.warpItem.cmd, (boolean)true);
            }
            this.gui.closeGui();
        }
    }
}

