/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbu.api.guide.IGuideGui;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

public class ButtonGuidePage
extends Button {
    public final IGuidePage page;
    public String hover;
    private boolean mouseOver;
    private boolean prevMouseOver = false;
    private boolean isSmall;

    public ButtonGuidePage(GuiBase gui, IGuidePage p, boolean small) {
        super(gui, 0, 0, 0, 0);
        this.page = p;
        this.isSmall = small;
        this.setHeight(p.getIcon().isEmpty() || this.isSmall ? 13 : 18);
        this.updateTitle();
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        ((IGuideGui)this.gui).setSelectedPage(this.page);
    }

    public void updateTitle() {
        ITextComponent titleC = this.page.getDisplayName().func_150259_f();
        if (this.mouseOver) {
            titleC.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        this.setTitle(titleC.func_150254_d());
        this.hover = null;
        this.setWidth(this.gui.getStringWidth(this.getTitle()) + (this.page.getIcon().isEmpty() ? 0 : this.height));
        if (this.width > this.getParentPanel().width) {
            this.hover = this.page.getDisplayName().func_150254_d();
        }
    }

    public void addMouseOverText(List<String> list) {
        if (this.hover != null) {
            list.add(this.hover);
        }
    }

    public void renderWidget() {
        boolean selected;
        this.mouseOver = this.gui.isMouseOver((Widget)this);
        if (this.mouseOver) {
            this.getParentPanel().setOffset(false);
            this.mouseOver = this.gui.isMouseOver((Widget)this.getParentPanel());
            this.getParentPanel().setOffset(true);
        }
        if (this.prevMouseOver != this.mouseOver) {
            this.updateTitle();
            this.prevMouseOver = this.mouseOver;
        }
        int ay = this.getAY();
        int ax = this.getAX();
        boolean bl = selected = this.gui instanceof IGuideGui && ((IGuideGui)this.gui).getSelectedPage() == this.page;
        if (!this.page.getIcon().isEmpty()) {
            this.page.getIcon().draw(ax + 1, ay + 1, this.isSmall ? 8 : 16, this.isSmall ? 8 : 16);
            if (selected) {
                this.gui.drawString(this.getTitle(), ax + (this.isSmall ? 14 : 20), ay + (this.isSmall ? 2 : 7), this.gui.getTheme().getContentColor().mutable().addBrightness(-30), 0);
            }
            this.gui.drawString(this.getTitle(), ax + (this.isSmall ? 13 : 19), ay + (this.isSmall ? 1 : 6));
        } else {
            if (selected) {
                this.gui.drawString(this.getTitle(), ax + 2, ay + 2, this.gui.getTheme().getContentColor().mutable().addBrightness(-30), 0);
            }
            this.gui.drawString(this.getTitle(), ax + 1, ay + 1);
        }
    }
}

