/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Theme;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.PartIcon;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbu.api.guide.IGuideGui;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbu.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbu.gui.guide.ButtonGuidePage;
import com.feed_the_beast.ftbu.gui.guide.Guides;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.event.ClickEvent;

public class GuiGuide
extends GuiBase
implements IGuideGui {
    private static final Color4I COLOR_BACKGROUND = Color4I.rgb((int)16250074);
    private static final Color4I COLOR_TEXT = Color4I.rgb((int)8086836);
    private static final Icon TEX_BACK = Icon.getIcon((String)"ftbu:textures/gui/guide/button_back.png").withUVfromCoords(0, 0, 14, 11, 16, 16).withTint(COLOR_TEXT);
    private static final Icon TEX_CLOSE = Icon.getIcon((String)"ftbu:textures/gui/guide/button_close.png").withUVfromCoords(0, 0, 14, 11, 16, 16).withTint(COLOR_TEXT);
    private static final Icon FILLING = COLOR_BACKGROUND.withBorder(4);
    private static final Theme GUIDE_THEME = new Theme(){
        private final Icon GUI = new PartIcon(Icon.getIcon((String)"ftbu:textures/gui/guide/frame.png"), 32, 12, 1);
        private final Icon TEXTURE_SCROLL = Icon.getIcon((String)"ftbu:textures/gui/guide/scroll.png");
        private final Icon TEX_SCROLL_V = this.TEXTURE_SCROLL.withUVfromCoords(0, 14, 12, 18, 32, 32);
        private final Icon TEX_SCROLL_H = this.TEXTURE_SCROLL.withUVfromCoords(14, 0, 18, 12, 32, 32);

        public Color4I getContentColor() {
            return COLOR_TEXT;
        }

        public Icon getGui(boolean mouseOver) {
            return this.GUI;
        }

        public Icon getWidget(boolean mouseOver) {
            return Icon.EMPTY;
        }

        public Icon getSlot(boolean mouseOver) {
            return Icon.EMPTY;
        }

        public Icon getScrollBarBackground() {
            return Icon.EMPTY;
        }

        public Icon getScrollBar(boolean grabbed, boolean vertical) {
            return vertical ? this.TEX_SCROLL_V : this.TEX_SCROLL_H;
        }
    };
    public final IGuidePage pageTree;
    public final Panel panelPages;
    public final Panel panelText;
    public final Panel panelTitle;
    public final PanelScrollBar sliderPages;
    public final PanelScrollBar sliderTextV;
    private final Button buttonBack;
    public int panelWidth;
    private final List<ButtonSpecial> specialButtons;
    private IGuidePage selectedPage;

    public GuiGuide(IGuidePage tree) {
        super(0, 0);
        this.selectedPage = this.pageTree = tree;
        this.buttonBack = new Button(this, 12, 12, 14, 11){

            public void onClicked(MouseButton button) {
                GuiHelper.playClickSound();
                GuiGuide.this.sliderPages.setValue(0.0);
                GuiGuide.this.sliderTextV.setValue(0.0);
                GuiGuide.this.setSelectedPage(GuiGuide.this.selectedPage.getParent());
            }

            public String getTitle() {
                return GuiGuide.this.selectedPage.getParent() == null ? GuiLang.CLOSE.translate() : GuiLang.BACK.translate();
            }
        };
        this.buttonBack.setIcon(TEX_CLOSE);
        this.panelPages = new Panel(this, 0, 0, 0, 0){

            public void addWidgets() {
                for (IGuidePage c : GuiGuide.this.selectedPage.getChildren().values()) {
                    this.add(c.createWidget(GuiGuide.this));
                }
                GuiGuide.this.panelTitle.refreshWidgets();
            }

            public void updateWidgetPositions() {
                if (!this.widgets.isEmpty()) {
                    GuiGuide.this.sliderPages.setElementSize(this.align(WidgetLayout.VERTICAL));
                }
            }
        };
        this.panelPages.addFlags(3);
        this.panelText = new Panel(this, 0, 0, 0, 0){
            private final WidgetLayout LAYOUT;
            {
                this.LAYOUT = new WidgetLayout.Vertical(2, 0, 4);
            }

            public void addWidgets() {
                for (Widget w : GuiGuide.this.panelPages.widgets) {
                    if (!(w instanceof ButtonGuidePage)) continue;
                    ((ButtonGuidePage)w).updateTitle();
                }
                this.gui.pushFontUnicode(true);
                for (IGuideTextLine line : GuiGuide.this.selectedPage.getText()) {
                    this.add(line == null ? new Widget(this.gui, 0, 0, GuiGuide.this.panelText.width, this.gui.getFontHeight() + 1) : line.createWidget(GuiGuide.this, GuiGuide.this.panelText));
                }
                this.gui.popFontUnicode();
            }

            public void updateWidgetPositions() {
                if (!this.widgets.isEmpty()) {
                    int s = this.align(this.LAYOUT);
                    GuiGuide.this.sliderTextV.setElementSize(s);
                    GuiGuide.this.sliderTextV.setSrollStepFromOneElementSize((s - 6) / this.widgets.size());
                }
            }
        };
        this.panelText.addFlags(11);
        this.panelTitle = new Panel(this, 0, 0, 0, 0){

            public void addWidgets() {
                this.add((Widget)GuiGuide.this.buttonBack);
                GuiGuide.this.buttonBack.setIcon(GuiGuide.this.selectedPage.getParent() == null ? TEX_CLOSE : TEX_BACK);
                GuiGuide.this.specialButtons.clear();
                for (SpecialGuideButton button : GuiGuide.this.selectedPage.getSpecialButtons()) {
                    GuiGuide.this.specialButtons.add(new ButtonSpecial(this.gui, button));
                }
                this.addAll(GuiGuide.this.specialButtons);
            }
        };
        this.sliderPages = new PanelScrollBar((GuiBase)this, 0, 0, 12, 0, 18, this.panelPages);
        this.sliderTextV = new PanelScrollBar((GuiBase)this, 0, 0, 12, 0, 18, this.panelText);
        this.specialButtons = new ArrayList<ButtonSpecial>();
    }

    @Override
    public IGuidePage getSelectedPage() {
        return this.selectedPage;
    }

    @Override
    public void setSelectedPage(@Nullable IGuidePage p) {
        this.sliderTextV.setValue(0.0);
        if (this.selectedPage != p) {
            if (p == null) {
                ClientUtils.MC.field_71439_g.func_71053_j();
                return;
            }
            this.selectedPage = p;
            if (p.getChildren().isEmpty()) {
                this.panelText.refreshWidgets();
            } else {
                this.sliderPages.setValue(0.0);
                this.refreshWidgets();
            }
        }
        this.panelTitle.refreshWidgets();
    }

    public void addWidgets() {
        this.add((Widget)this.sliderTextV);
        this.add((Widget)this.panelPages);
        this.add((Widget)this.panelText);
        this.add((Widget)this.panelTitle);
        this.add((Widget)this.sliderPages);
        this.panelPages.setWidth(this.panelWidth - (this.sliderPages.isEnabled() ? 32 : 17));
        for (int i = 0; i < this.specialButtons.size(); ++i) {
            ButtonSpecial b = this.specialButtons.get(i);
            b.posX = this.panelWidth - 24 - 20 * i;
            b.posY = 10;
        }
        if (!Guides.pageToOpen.isEmpty()) {
            this.setSelectedPage(this.pageTree.getSubRaw(Guides.pageToOpen));
            Guides.pageToOpen = "";
        }
    }

    public void onInit() {
        this.posX = 3;
        this.posY = 3;
        this.setWidth(this.getScreen().func_78326_a() - this.posX * 2);
        this.setHeight(this.getScreen().func_78328_b() - this.posY * 2);
        this.panelTitle.width = this.panelWidth = (int)((double)this.width * 0.3);
        this.panelTitle.height = 46;
        this.panelPages.posX = 10;
        this.panelPages.posY = 43;
        this.panelPages.setWidth(this.panelWidth - 17);
        this.panelPages.setHeight(this.height - 49);
        this.panelText.posX = this.panelWidth + 10;
        this.panelText.posY = 6;
        this.panelText.setWidth(this.width - this.panelWidth - 23 - this.sliderTextV.width);
        this.panelText.setHeight(this.height - 12);
        this.sliderPages.posX = this.panelWidth - this.sliderPages.width - 10;
        this.sliderPages.posY = 46;
        this.sliderPages.setHeight(this.height - 56);
        this.sliderTextV.posY = 10;
        this.sliderTextV.setHeight(this.height - 20);
        this.sliderTextV.posX = this.width - 10 - this.sliderTextV.width;
    }

    public void drawBackground() {
        FILLING.draw(this.posX + this.panelWidth, this.posY, this.width - this.panelWidth, this.height);
        FILLING.draw(this.posX, this.posY + 36, this.panelWidth, this.height - 36);
        FILLING.draw(this.posX, this.posY, this.panelWidth, 36);
        GuiHelper.pushScissor((ScaledResolution)this.getScreen(), (int)this.posX, (int)this.posY, (int)this.panelWidth, (int)36);
        this.drawString(this.selectedPage.getDisplayName().func_150254_d(), this.buttonBack.getAX() + this.buttonBack.width + 5, this.posY + 14);
        GuiHelper.popScissor((ScaledResolution)this.getScreen());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawForeground() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getTheme().getGui(false).draw(this.posX + this.panelWidth, this.posY + 1, this.width - this.panelWidth - 1, this.height - 2);
        this.getTheme().getGui(false).draw(this.posX + 1, this.posY + 36, this.panelWidth - 2, this.height - 37);
        this.getTheme().getGui(false).draw(this.posX + 1, this.posY + 1, this.panelWidth - 2, 34);
        super.drawForeground();
    }

    public Theme getTheme() {
        return GUIDE_THEME;
    }

    public boolean drawDefaultBackground() {
        return false;
    }

    public boolean changePage(String value) {
        IGuidePage page = this.pageTree.getSubRaw(value);
        if (page != null) {
            if (page.getParent() != null) {
                this.setSelectedPage(page.getParent());
            }
            this.setSelectedPage(page);
        }
        return false;
    }

    @Nullable
    public GuiScreen getPrevScreen() {
        return null;
    }

    public Icon getIcon() {
        return Icon.EMPTY;
    }

    private static class ButtonSpecial
    extends Button {
        private final SpecialGuideButton specialInfoButton;

        public ButtonSpecial(GuiBase gui, SpecialGuideButton b) {
            super(gui, 0, 0, 16, 16);
            this.specialInfoButton = b;
            this.setTitle(this.specialInfoButton.title.func_150254_d());
        }

        public void onClicked(MouseButton button) {
            if (GuiHelper.onClickEvent((ClickEvent)this.specialInfoButton.clickEvent)) {
                GuiHelper.playClickSound();
            }
        }

        public void renderWidget() {
            this.specialInfoButton.icon.draw((Widget)this);
        }
    }
}

