/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.gui.Button;
import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.gui.guide.EmptyGuidePageLine;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.lwjgl.opengl.GL11;

public class GuideImageLine
extends EmptyGuidePageLine {
    public Icon icon = Icon.EMPTY;
    public int imageWidth;
    public int imageHeight;
    public double imageScale = 1.0;
    public ClickEvent clickEvent;
    public List<String> hover;

    public GuideImageLine() {
    }

    public GuideImageLine(JsonElement e) {
        this.icon = Icon.EMPTY;
        this.imageHeight = 0;
        this.imageWidth = 0;
        this.imageScale = 1.0;
        this.hover = null;
        JsonObject o = e.getAsJsonObject();
        if (!o.has("image")) {
            return;
        }
        this.icon = Icon.getIcon((JsonElement)o.get("image"));
        if (o.has("scale")) {
            this.imageScale = o.get("scale").getAsDouble();
        } else if (o.has("size")) {
            this.imageWidth = this.imageHeight = o.get("size").getAsInt();
        } else {
            if (o.has("width")) {
                this.imageWidth = o.get("width").getAsInt();
            }
            if (o.has("height")) {
                this.imageHeight = o.get("height").getAsInt();
            }
        }
        if (o.has("click")) {
            this.clickEvent = JsonUtils.deserializeClickEvent((JsonElement)o.get("click"));
        }
        if (o.has("hover")) {
            this.hover = new ArrayList<String>();
            for (JsonElement e1 : o.get("hover").getAsJsonArray()) {
                ITextComponent c = JsonUtils.deserializeTextComponent((JsonElement)e1);
                this.hover.add(c == null ? "" : c.func_150254_d());
            }
        }
        if (this.hover == null || this.hover.isEmpty()) {
            this.hover = Collections.emptyList();
        }
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new ButtonInfoImage(gui, parent);
    }

    @Override
    public GuideImageLine copy(IGuidePage page) {
        GuideImageLine line = new GuideImageLine();
        line.icon = this.icon;
        line.imageWidth = this.imageWidth;
        line.imageHeight = this.imageHeight;
        line.imageScale = this.imageScale;
        line.clickEvent = this.clickEvent;
        line.hover = this.hover.isEmpty() ? Collections.emptyList() : new ArrayList<String>(this.hover);
        return line;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private class ButtonInfoImage
    extends Button {
        private final Panel parent;

        private ButtonInfoImage(GuiBase gui, Panel p) {
            super(gui, 0, 0, 0, 0);
            this.parent = p;
            this.checkSize();
        }

        private void checkSize() {
            GuideImageLine.this.icon.bindTexture();
            if (this.width <= 0 || this.height <= 0) {
                this.width = Math.max(GuideImageLine.this.imageWidth == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096) : GuideImageLine.this.imageWidth, 1);
                this.height = Math.max(GuideImageLine.this.imageHeight == 0 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097) : GuideImageLine.this.imageHeight, 1);
                double scale = GuideImageLine.this.imageScale < 0.0 ? 1.0 / -GuideImageLine.this.imageScale : GuideImageLine.this.imageScale;
                double w = Math.min((double)this.parent.width, (double)this.width * scale);
                double h = (double)this.height * (w / ((double)this.width * scale));
                this.setWidth(Math.max((int)w, 0));
                this.setHeight(Math.max((int)h, 0));
                this.parent.updateWidgetPositions();
            }
        }

        public void renderWidget() {
            this.checkSize();
            GuideImageLine.this.icon.draw((Widget)this);
        }

        public void addMouseOverText(List<String> list) {
            if (!GuideImageLine.this.hover.isEmpty()) {
                list.addAll(GuideImageLine.this.hover);
            }
        }

        public void onClicked(MouseButton button) {
            if (GuiHelper.onClickEvent((ClickEvent)GuideImageLine.this.clickEvent)) {
                GuiHelper.playClickSound();
            }
        }
    }
}

