/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Panel;
import com.feed_the_beast.ftbl.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftbl.lib.gui.ScrollBar;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbl.lib.icon.BulletIcon;
import com.feed_the_beast.ftbl.lib.icon.Color4I;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.util.misc.NameMap;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbu.gui.guide.EmptyGuidePageLine;
import com.feed_the_beast.ftbu.gui.guide.GuidePage;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.IStringSerializable;

public class GuideListLine
extends EmptyGuidePageLine {
    private static final Icon CODE_BACKGROUND = Color4I.rgba((int)0x33AAAAAA);
    private static final Icon SCROLL_BAR_BACKGROUND = Color4I.rgba((int)0x33333333);
    private final List<IGuideTextLine> textLines;
    private final Type type;
    private final Ordering ordering;
    private final int spacing;

    public GuideListLine(GuidePage p, JsonElement json) {
        this.textLines = new ArrayList<IGuideTextLine>();
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            if (o.has("list")) {
                for (JsonElement element : o.get("list").getAsJsonArray()) {
                    IGuideTextLine line = p.createLine(element);
                    if (line == null) continue;
                    this.textLines.add(line);
                }
            }
            this.type = o.has("type") ? (Type)((Object)Type.NAME_MAP.get(o.get("type").getAsString())) : Type.NONE;
            this.ordering = this.type != Type.HORIZONTAL && o.has("ordering") ? (Ordering)((Object)Ordering.NAME_MAP.get(o.get("ordering").getAsString())) : this.type.defaultOrdering;
            this.spacing = o.has("spacing") ? o.get("spacing").getAsInt() : 0;
        } else {
            for (JsonElement element : json.getAsJsonArray()) {
                IGuideTextLine line = p.createLine(element);
                if (line == null) continue;
                this.textLines.add(line);
            }
            this.type = Type.NONE;
            this.ordering = this.type.defaultOrdering;
            this.spacing = 0;
        }
    }

    public GuideListLine(List<IGuideTextLine> l, Type t, Ordering o, int s) {
        this.textLines = l;
        this.type = t;
        this.ordering = this.type == Type.HORIZONTAL ? Ordering.NONE : o;
        this.spacing = s;
    }

    @Override
    public Widget createWidget(GuiBase gui, Panel parent) {
        return new PanelList(gui, parent.hasFlag(8));
    }

    @Override
    public GuideListLine copy(IGuidePage page) {
        GuideListLine line = new GuideListLine(new ArrayList<IGuideTextLine>(this.textLines.size()), this.type, this.ordering, this.spacing);
        for (IGuideTextLine line1 : this.textLines) {
            line.textLines.add(line1.copy(page));
        }
        return line;
    }

    @Override
    public boolean isEmpty() {
        for (IGuideTextLine line : this.textLines) {
            if (line.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private class PanelList
    extends Panel {
        private final PanelScrollBar scrollBar;
        private final WidgetLayout layout;
        private BulletIcon bullet;

        private PanelList(GuiBase gui, boolean unicodeFont) {
            super(gui, ((GuideListLine)GuideListLine.this).ordering.size, 0, 0, 0);
            this.scrollBar = new PanelScrollBar(gui, 0, 0, 1, 4, 0, this){

                public ScrollBar.Plane getPlane() {
                    return ScrollBar.Plane.HORIZONTAL;
                }

                public Icon getBackground() {
                    return SCROLL_BAR_BACKGROUND;
                }

                public boolean canMouseScroll() {
                    return this.gui.isMouseOver((Widget)this.getParentPanel());
                }
            };
            if (unicodeFont) {
                this.addFlags(8);
            }
            this.layout = ((GuideListLine)GuideListLine.this).type.plane.isVertical() ? new WidgetLayout.Vertical(0, GuideListLine.this.spacing, 0) : new WidgetLayout.Horizontal(0, GuideListLine.this.spacing, 0);
            this.bullet = new BulletIcon().setColor(gui.getTheme().getContentColor());
        }

        public void addWidgets() {
            if (GuideListLine.this.isEmpty()) {
                this.setWidth(0);
                this.setHeight(0);
                return;
            }
            this.setWidth(GuideListLine.this.type == Type.CODE ? 0 : this.getParentPanel().width - ((GuideListLine)GuideListLine.this).ordering.size);
            for (IGuideTextLine line : GuideListLine.this.textLines) {
                this.add(line.createWidget(this.gui, this));
            }
            this.getParentPanel().add((Widget)this.scrollBar);
            this.updateWidgetPositions();
        }

        public void updateWidgetPositions() {
            int s;
            if (this.widgets.isEmpty()) {
                this.setWidth(0);
                this.setHeight(0);
                return;
            }
            this.align(this.layout);
            Widget last = (Widget)this.widgets.get(this.widgets.size() - 1);
            if (!((GuideListLine)GuideListLine.this).type.plane.isVertical()) {
                this.setHeight(0);
                for (Widget widget : this.widgets) {
                    this.setHeight(Math.max(this.height, widget.height));
                }
                s = last.posX + last.width;
            } else {
                this.setHeight(last.posY + last.height);
                s = 0;
                for (Widget widget : this.widgets) {
                    s = Math.max(s, widget.width);
                }
                s += ((GuideListLine)GuideListLine.this).ordering.size;
            }
            this.setWidth(Math.min(s, this.getParentPanel().width) - ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setWidth(this.width + ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setElementSize(s - ((GuideListLine)GuideListLine.this).ordering.size);
            this.scrollBar.setSrollStepFromOneElementSize(10);
            this.scrollBar.sliderSize = this.scrollBar.width / 10;
        }

        protected void renderWidget(Widget widget, int index, int ax, int ay, int w, int h) {
            widget.renderWidget();
            if (((GuideListLine)GuideListLine.this).ordering.size > 0 && widget.getClass() != Widget.class && !(widget instanceof PanelList)) {
                switch (GuideListLine.this.ordering) {
                    case BULLET: {
                        this.bullet.draw(ax - 7, widget.getAY() + 3, 4, 4);
                        break;
                    }
                    case NUMBER: {
                        String n = Integer.toString(index + 1);
                        this.gui.drawString(n, ax - 1 - this.gui.getStringWidth(n), widget.getAY() + 1);
                        break;
                    }
                    case LETTER: {
                        char c = (char)(97 + index);
                        if (c > 'z') {
                            c = (char)(65 + index);
                        }
                        if (c > 'Z') {
                            c = '-';
                        }
                        String n = Character.toString(c);
                        this.gui.drawString(n, ax - 1 - this.gui.getStringWidth(n), widget.getAY() + 1);
                    }
                }
            }
        }

        protected void renderPanelBackground(int ax, int ay) {
            if (GuideListLine.this.type == Type.CODE) {
                CODE_BACKGROUND.draw(ax - ((GuideListLine)GuideListLine.this).ordering.size, ay, this.width + ((GuideListLine)GuideListLine.this).ordering.size, this.height);
            }
        }
    }

    public static enum Type implements IStringSerializable
    {
        NONE("none", ScrollBar.Plane.VERTICAL, Ordering.BULLET),
        CODE("code", ScrollBar.Plane.VERTICAL, Ordering.NONE),
        HORIZONTAL("horizontal", ScrollBar.Plane.HORIZONTAL, Ordering.NONE);

        public static final NameMap<Type> NAME_MAP;
        private final String name;
        public final ScrollBar.Plane plane;
        public final Ordering defaultOrdering;

        private Type(String s, ScrollBar.Plane d, Ordering o) {
            this.name = s;
            this.plane = d;
            this.defaultOrdering = o;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_MAP = NameMap.create((Object)((Object)NONE), (Object[])Type.values());
        }
    }

    public static enum Ordering implements IStringSerializable
    {
        NONE("none", 0),
        BULLET("bullet", 8),
        NUMBER("number", 12),
        LETTER("letter", 10);

        public static final NameMap<Ordering> NAME_MAP;
        private final String name;
        public final int size;

        private Ordering(String n2, int s) {
            this.name = n2;
            this.size = s;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_MAP = NameMap.create((Object)((Object)BULLET), (Object[])Ordering.values());
        }
    }
}

