/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.gui.GuiBase;
import com.feed_the_beast.ftbl.lib.gui.Widget;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.FinalIDObject;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.api.guide.IGuideTextLine;
import com.feed_the_beast.ftbu.api.guide.IGuideTextLineProvider;
import com.feed_the_beast.ftbu.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbu.gui.guide.ButtonGuidePage;
import com.feed_the_beast.ftbu.gui.guide.GuideExtendedTextLine;
import com.feed_the_beast.ftbu.gui.guide.GuideTextLineString;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class GuidePage
extends FinalIDObject
implements IGuidePage {
    public static final Map<String, IGuideTextLineProvider> LINE_PROVIDERS = new HashMap<String, IGuideTextLineProvider>();
    private final IGuidePage parent;
    private final List<IGuideTextLine> text;
    private final LinkedHashMap<String, IGuidePage> childPages;
    private ITextComponent title;
    private Icon pageIcon;
    private final List<SpecialGuideButton> specialButtons;

    public GuidePage(String id, @Nullable IGuidePage p) {
        super(id);
        this.parent = p;
        this.text = new ArrayList<IGuideTextLine>();
        this.childPages = new LinkedHashMap(0);
        this.pageIcon = Icon.EMPTY;
        this.specialButtons = new ArrayList<SpecialGuideButton>();
    }

    @Override
    public void fromJson(JsonObject json) {
        if (json.has("title")) {
            this.setTitle(JsonUtils.deserializeTextComponent((JsonElement)json.get("title")));
        }
        if (json.has("text")) {
            JsonArray a = json.get("text").getAsJsonArray();
            for (int i = 0; i < a.size(); ++i) {
                this.text.add(this.createLine(a.get(i)));
            }
        }
        if (json.has("pages")) {
            JsonObject o1 = json.get("pages").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                GuidePage p = new GuidePage((String)entry.getKey(), this);
                p.fromJson(((JsonElement)entry.getValue()).getAsJsonObject());
                this.childPages.put(p.func_176610_l(), p);
            }
        }
        if (json.has("icon")) {
            this.pageIcon = Icon.getIcon((JsonElement)json.get("icon"));
        }
        if (json.has("buttons")) {
            for (JsonElement e : json.get("buttons").getAsJsonArray()) {
                this.specialButtons.add(new SpecialGuideButton(e.getAsJsonObject()));
            }
        }
    }

    @Override
    @Nullable
    public IGuidePage getParent() {
        return this.parent;
    }

    @Override
    public ITextComponent getDisplayName() {
        return this.title == null ? new TextComponentString(this.func_176610_l()) : this.title;
    }

    @Override
    @Nullable
    public ITextComponent getTitle() {
        return this.title;
    }

    @Override
    public IGuidePage setTitle(@Nullable ITextComponent t) {
        this.title = t;
        return this;
    }

    @Override
    public void println(@Nullable Object o) {
        if (o == null) {
            this.text.add(null);
        } else if (o instanceof IGuideTextLine) {
            String text;
            if (o instanceof GuideTextLineString && (text = ((GuideTextLineString)o).getUnformattedText()).isEmpty()) {
                this.println(null);
                return;
            }
            this.text.add((IGuideTextLine)o);
        } else if (o instanceof ITextComponent) {
            ITextComponent c = (ITextComponent)o;
            if (c instanceof TextComponentString && c.func_150256_b().func_150229_g() && c.func_150253_a().isEmpty()) {
                this.text.add(new GuideTextLineString(((TextComponentString)c).func_150265_g()));
            } else {
                this.text.add(new GuideExtendedTextLine(c));
            }
        } else if (o instanceof IGuidePage) {
            this.copyFrom((IGuidePage)o);
        } else {
            this.text.add(new GuideTextLineString(String.valueOf(o)));
        }
    }

    @Override
    public List<IGuideTextLine> getText() {
        return this.text;
    }

    @Override
    public Map<String, IGuidePage> getChildren() {
        return this.childPages;
    }

    @Override
    public IGuidePage getSub(String id) {
        IGuidePage p = this.childPages.get(id);
        if (p == null) {
            p = this.addSub(new GuidePage(id, this));
        }
        return p;
    }

    @Override
    public List<SpecialGuideButton> getSpecialButtons() {
        return this.specialButtons;
    }

    @Override
    public IGuidePage setIcon(Icon icon) {
        this.pageIcon = icon;
        return this;
    }

    @Override
    public Icon getIcon() {
        return this.pageIcon;
    }

    @Override
    public Widget createWidget(GuiBase gui) {
        return new ButtonGuidePage(gui, this, false);
    }

    @Override
    @Nullable
    public IGuideTextLine createLine(@Nullable JsonElement json) {
        ITextComponent component;
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonPrimitive()) {
            String s = json.getAsString().replace("\t", "  ");
            return s.trim().isEmpty() ? null : new GuideTextLineString(s);
        }
        if (json.isJsonArray()) {
            return new GuideExtendedTextLine(json);
        }
        JsonObject o = json.getAsJsonObject();
        IGuideTextLineProvider provider = null;
        if (o.has("id")) {
            String id = o.get("id").getAsString();
            provider = LINE_PROVIDERS.get(id);
            if (provider == null) {
                ITextComponent component2 = FTBLibLang.ERROR.textComponent(null, new Object[]{id});
                component2.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
                component2.func_150256_b().func_150227_a(Boolean.valueOf(true));
                return new GuideExtendedTextLine(component2);
            }
        } else if (o.has("h1")) {
            component = JsonUtils.deserializeTextComponent((JsonElement)o.get("h1"));
            if (component != null) {
                component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                return new GuideExtendedTextLine(component);
            }
        } else if (o.has("h2")) {
            component = JsonUtils.deserializeTextComponent((JsonElement)o.get("h2"));
            if (component != null) {
                component.func_150256_b().func_150227_a(Boolean.valueOf(true));
                return new GuideExtendedTextLine(component);
            }
        } else if (o.has("list")) {
            provider = LINE_PROVIDERS.get("list");
        } else if (o.has("image") || o.has("img")) {
            provider = LINE_PROVIDERS.get("image");
        }
        IGuideTextLine line = provider != null ? provider.create(this, json) : new GuideExtendedTextLine(json);
        return line;
    }
}

