/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.gui.guide;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.gui.GuiHelper;
import com.feed_the_beast.ftbl.lib.gui.GuiIcons;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.ItemIcon;
import com.feed_the_beast.ftbl.lib.internal.FTBLibLang;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.guide.ClientGuideEvent;
import com.feed_the_beast.ftbu.api.guide.GuideType;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.api.guide.IGuideTitlePage;
import com.feed_the_beast.ftbu.api.guide.SpecialGuideButton;
import com.feed_the_beast.ftbu.gui.guide.GuiGuide;
import com.feed_the_beast.ftbu.gui.guide.GuideContentsLine;
import com.feed_the_beast.ftbu.gui.guide.GuideHrLine;
import com.feed_the_beast.ftbu.gui.guide.GuidePage;
import com.feed_the_beast.ftbu.gui.guide.GuideTitlePage;
import com.feed_the_beast.ftbu.net.MessageRequestServerInfo;
import com.feed_the_beast.ftbu.net.MessageServerInfo;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum Guides implements IResourceManagerReloadListener
{
    INSTANCE;

    public static final IGuidePage INFO_PAGE;
    public static final IGuidePage SERVER_INFO_PAGE;
    public static String pageToOpen;
    private static boolean isReloading;
    private static Thread reloadingThread;
    private static GuiGuide cachedGui;
    public static final Runnable OPEN_GUI;

    public static void setShouldReload() {
        cachedGui = null;
    }

    public static void refresh() {
        GuiHelper.playClickSound();
        Guides.setShouldReload();
        OPEN_GUI.run();
    }

    public static void readServerInfoPage(MessageServerInfo m) {
        SERVER_INFO_PAGE.clear();
        if (m.serverGuide.isJsonObject()) {
            SERVER_INFO_PAGE.fromJson(m.serverGuide.getAsJsonObject());
        }
        for (JsonElement element : m.mainPage) {
            ITextComponent component = JsonUtils.deserializeTextComponent((JsonElement)element);
            SERVER_INFO_PAGE.println(component);
        }
        IGuidePage commandPage = SERVER_INFO_PAGE.getSub("commands");
        for (MessageServerInfo.CommandInfo info : m.commands.subcommands) {
            Guides.addCommandTree(commandPage, info);
        }
        commandPage.sort(true);
        commandPage.setTitle((ITextComponent)new TextComponentTranslation("commands", new Object[0]));
        commandPage.setIcon(ItemIcon.getItemIcon((ItemStack)new ItemStack(Blocks.field_150483_bI)));
        if (cachedGui != null && cachedGui.getSelectedPage() == SERVER_INFO_PAGE) {
            cachedGui.refreshWidgets();
        }
    }

    private static void addCommandTree(IGuidePage page, MessageServerInfo.CommandInfo info) {
        IGuidePage subPage = page.getSub(info.name);
        subPage.setTitle((ITextComponent)new TextComponentString("/" + info.name));
        if (!info.info.isEmpty()) {
            for (ITextComponent component : info.info) {
                subPage.println(component);
            }
        }
        if (!info.subcommands.isEmpty()) {
            for (MessageServerInfo.CommandInfo info1 : info.subcommands) {
                Guides.addCommandTree(subPage, info1);
            }
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        FTBUFinals.LOGGER.info("Reloading guides...");
        INFO_PAGE.clear();
        INFO_PAGE.setTitle((ITextComponent)new TextComponentTranslation("sidebar_button.ftbu.guide", new Object[0]));
        ArrayList<GuideTitlePage> guides = new ArrayList<GuideTitlePage>();
        for (String domain : resourceManager.func_135055_a()) {
            try {
                IResource iResource = resourceManager.func_110536_a(new ResourceLocation(domain, "guide/guide.json"));
                JsonElement infoFile = JsonUtils.fromJson((Reader)new InputStreamReader(iResource.func_110527_b()));
                if (!infoFile.isJsonObject()) continue;
                JsonObject json = infoFile.getAsJsonObject();
                GuideType type = json.has("type") ? (GuideType)((Object)GuideType.NAME_MAP.get(json.get("type").getAsString())) : GuideType.OTHER;
                GuideTitlePage guide = new GuideTitlePage(domain, type);
                guide.setTitle((ITextComponent)new TextComponentTranslation(domain + ".guide", new Object[0]));
                if (!json.has("icon")) {
                    guide.setIcon(Icon.getIcon((String)(domain + ":textures/icon.png")));
                }
                for (JsonElement element : JsonUtils.toArray((JsonElement)json.get("authors"))) {
                    guide.getAuthors().add(element.getAsString());
                }
                if (json.has("guide_authors")) {
                    for (JsonElement element : JsonUtils.toArray((JsonElement)json.get("guide_authors"))) {
                        guide.getGuideAuthors().add(element.getAsString());
                    }
                } else {
                    guide.getGuideAuthors().addAll(guide.getAuthors());
                }
                Guides.loadPage(resourceManager, domain, guide, json, "guide");
                if (guide.getChildren().size() > 0) {
                    guide.println(new GuideHrLine(1, Icon.EMPTY));
                    guide.println(new GuideContentsLine(guide));
                }
                guides.add(guide);
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) continue;
                exception.printStackTrace();
            }
        }
        HashMap<String, IGuideTitlePage> eventMap = new HashMap<String, IGuideTitlePage>();
        new ClientGuideEvent(eventMap, resourceManager, modid -> {
            GuideTitlePage page = new GuideTitlePage((String)modid, GuideType.MOD);
            ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(modid);
            if (mod != null) {
                page.getAuthors().addAll(mod.getMetadata().authorList);
                if (!mod.getMetadata().description.isEmpty()) {
                    for (String s : mod.getMetadata().description.split("\n")) {
                        page.println(s);
                    }
                }
                page.setTitle((ITextComponent)new TextComponentString(mod.getName()));
            }
            return page;
        }).post();
        guides.addAll(eventMap.values());
        for (IGuideTitlePage iGuideTitlePage : guides) {
            INFO_PAGE.addSub(iGuideTitlePage);
        }
        INFO_PAGE.cleanup();
        INFO_PAGE.addSub(SERVER_INFO_PAGE);
        INFO_PAGE.sort(false);
    }

    private static void loadPage(IResourceManager resourceManager, String domain, IGuidePage page, JsonObject json, String currentDir) throws Exception {
        if (json.has("button")) {
            page.addSpecialButton(new SpecialGuideButton(json.get("button").getAsJsonObject()));
        } else if (json.has("buttons")) {
            for (JsonElement element : JsonUtils.toArray((JsonElement)json.get("buttons"))) {
                page.addSpecialButton(new SpecialGuideButton(element.getAsJsonObject()));
            }
        }
        if (json.has("name")) {
            page.setTitle(JsonUtils.deserializeTextComponent((JsonElement)json.get("name")));
        } else {
            page.setTitle((ITextComponent)new TextComponentTranslation("guide." + page.getFullId(), new Object[0]));
        }
        if (json.has("icon")) {
            page.setIcon(Icon.getIcon((JsonElement)json.get("icon")));
        }
        if (json.has("pages")) {
            for (Map.Entry entry : json.get("pages").getAsJsonObject().entrySet()) {
                IGuidePage sub = page.getSub((String)entry.getKey());
                try {
                    Guides.loadPage(resourceManager, domain, sub, ((JsonElement)entry.getValue()).getAsJsonObject(), currentDir + "/" + (String)entry.getKey());
                }
                catch (Exception ex) {
                    sub.println(StringUtils.color((ITextComponent)FTBLibLang.ERROR.textComponent(null).func_150258_a(ex.toString()), (TextFormatting)TextFormatting.RED));
                    ex.printStackTrace();
                }
            }
        }
        for (JsonElement element : JsonUtils.toArray((JsonElement)JsonUtils.fromJson((IResource)resourceManager.func_110536_a(new ResourceLocation(domain, currentDir + "/index.json"))))) {
            try {
                page.println(page.createLine(element));
            }
            catch (Exception ex) {
                page.println(StringUtils.color((ITextComponent)FTBLibLang.ERROR.textComponent(null).func_150258_a(ex.toString()), (TextFormatting)TextFormatting.RED));
                page.println(StringUtils.color((ITextComponent)new TextComponentString(element.toString()), (TextFormatting)TextFormatting.DARK_RED));
                ex.printStackTrace();
            }
        }
    }

    static {
        INFO_PAGE = new GuidePage("guides", null){

            @Override
            public String getFullId() {
                return "";
            }
        }.addSpecialButton(new SpecialGuideButton(GuiLang.REFRESH.textComponent(null), GuiIcons.REFRESH, new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ftbc refresh_guide")));
        SERVER_INFO_PAGE = new GuidePage("server_info", INFO_PAGE){

            @Override
            public GuideType getType() {
                return GuideType.SERVER_INFO;
            }
        }.setTitle((ITextComponent)new TextComponentTranslation("sidebar_button.ftbu.server_info", new Object[0])).setIcon(GuiIcons.BOOK_RED);
        pageToOpen = "";
        isReloading = false;
        reloadingThread = null;
        cachedGui = null;
        OPEN_GUI = () -> {
            new MessageRequestServerInfo().sendToServer();
            if (cachedGui == null) {
                if (!isReloading) {
                    isReloading = true;
                    new GuiLoading(){

                        public void startLoading() {
                            reloadingThread = new Thread(() -> {
                                INSTANCE.func_110549_a(ClientUtils.MC.func_110442_L());
                                isReloading = false;
                            });
                            reloadingThread.start();
                        }

                        public boolean isLoading() {
                            return isReloading;
                        }

                        public void finishLoading() {
                            reloadingThread = null;
                            cachedGui = new GuiGuide(INFO_PAGE);
                            cachedGui.openGuiLater();
                        }
                    }.openGuiLater();
                }
            } else if (!isReloading) {
                cachedGui.openGuiLater();
            }
        };
    }
}

