/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbl.lib.math.BlockPosContainer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.util.FTBUPlayerData;
import com.google.common.base.Objects;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="ftbu")
public class FTBUPlayerEventHandler {
    @SubscribeEvent
    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            FTBUPlayerData.get((IForgePlayer)FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)event.getEntity())).lastDeath = new BlockDimPos(event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onChunkChanged(EntityEvent.EnteringChunk event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
        IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer(player.func_146103_bH());
        if (p == null || p.isFake()) {
            return;
        }
        FTBUPlayerData.get((IForgePlayer)p).lastSafePos = new BlockDimPos((Entity)player);
        FTBUPlayerEventHandler.updateChunkMessage((EntityPlayer)player, new ChunkDimPos(event.getNewChunkX(), event.getNewChunkZ(), player.field_71093_bK));
    }

    public static void updateChunkMessage(EntityPlayer player, ChunkDimPos pos) {
        ClaimedChunk chunk = ClaimedChunks.INSTANCE.getChunk(pos);
        IForgeTeam team = chunk == null ? null : chunk.getTeam();
        FTBUPlayerData data = FTBUPlayerData.get(FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player));
        if (!Objects.equal((Object)data.lastChunkTeam, (Object)team)) {
            data.lastChunkTeam = team;
            if (team != null) {
                Notification notification = Notification.of((ResourceLocation)FTBUFinals.get("chunk_changed"), (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)new TextComponentString(team.getTitle()), (TextFormatting)team.getColor().getTextFormatting())});
                if (!team.getDesc().isEmpty()) {
                    notification.addLine(StringUtils.italic((ITextComponent)new TextComponentString(team.getDesc()), (boolean)true));
                }
                notification.send(player);
            } else {
                Notification.of((ResourceLocation)FTBUFinals.get("chunk_changed"), (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)FTBULang.CHUNKS_WILDERNESS.textComponent((ICommandSender)player), (TextFormatting)TextFormatting.DARK_GREEN)}).send(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityAttacked(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerAttackEntity((EntityPlayerMP)player, event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.INTERACT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.ITEM)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getState()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (event.getPlayer() instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getPlayer(), EnumHand.MAIN_HAND, new BlockPosContainer(event.getWorld(), event.getPos(), event.getPlacedBlock()), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntityPlayer() instanceof EntityPlayerMP && !ClaimedChunks.INSTANCE.canPlayerInteract((EntityPlayerMP)event.getEntityPlayer(), event.getHand(), new BlockPosContainer((PlayerInteractEvent)event), BlockInteractionType.EDIT)) {
            event.setCanceled(true);
        }
    }
}

