/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.gui.GuiLang;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBUtilitiesAPI;
import com.feed_the_beast.ftbu.api.IRank;
import com.feed_the_beast.ftbu.api.Leaderboard;
import java.util.Comparator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="ftbu")
public class FTBUServerEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onServerChatEvent(ServerChatEvent event) {
        String msg = event.getMessage().trim();
        if (FTBUConfig.ranks.override_chat) {
            IRank rank = FTBUtilitiesAPI.API.getRank(event.getPlayer().func_146103_bH());
            TextComponentString main = new TextComponentString("");
            TextComponentString name = new TextComponentString(rank.getFormattedName(event.getPlayer().getDisplayNameString()));
            name.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/msg " + event.getPlayer().func_70005_c_() + " "));
            NBTTagCompound hoverNBT = new NBTTagCompound();
            String s = EntityList.func_75621_b((Entity)event.getPlayer());
            hoverNBT.func_74778_a("id", event.getPlayer().func_189512_bd());
            if (s != null) {
                hoverNBT.func_74778_a("type", s);
            }
            hoverNBT.func_74778_a("name", event.getPlayer().func_70005_c_());
            name.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_ENTITY, (ITextComponent)new TextComponentString(hoverNBT.toString())));
            name.func_150256_b().func_179989_a(event.getPlayer().func_70005_c_());
            main.func_150257_a((ITextComponent)name);
            main.func_150257_a(ForgeHooks.newChatWithLinks((String)msg));
            event.setComponent((ITextComponent)main);
        }
    }

    @SubscribeEvent
    public static void registerRegistries(RegistryEvent.NewRegistry event) {
        FTBUCommon.LEADERBOARDS = new RegistryBuilder().setName(FTBUFinals.get("leaderboards")).setType(Leaderboard.class).setMaxID(255).create();
    }

    @SubscribeEvent
    public static void registerLeaderboards(RegistryEvent.Register<Leaderboard> event) {
        event.getRegistry().register(new Leaderboard.FromStat(StatList.field_188069_A, false, Leaderboard.FromStat.DEFAULT).setRegistryName("ftbu:deaths"));
        event.getRegistry().register(new Leaderboard.FromStat(StatList.field_188070_B, false, Leaderboard.FromStat.DEFAULT).setRegistryName("ftbu:mob_kills"));
        event.getRegistry().register(new Leaderboard.FromStat(StatList.field_188097_g, false, Leaderboard.FromStat.TIME).setRegistryName("ftbu:time_played"));
        event.getRegistry().register(new Leaderboard((ITextComponent)new TextComponentTranslation("ftbu.stat.dph", new Object[0]), player -> {
            double d = FTBUServerEventHandler.getDPH(player);
            return new TextComponentString(d < 0.0 ? "-" : String.format("%.2f", d));
        }, Comparator.comparingDouble(FTBUServerEventHandler::getDPH).reversed(), player -> FTBUServerEventHandler.getDPH(player) >= 0.0).setRegistryName("ftbu:deaths_per_hour"));
        event.getRegistry().register(new Leaderboard((ITextComponent)new TextComponentTranslation("ftbu.stat.last_seen", new Object[0]), player -> {
            if (player.isOnline()) {
                ITextComponent component = GuiLang.ONLINE.textComponent(null);
                component.func_150256_b().func_150238_a(TextFormatting.GREEN);
                return component;
            }
            return Leaderboard.FromStat.TIME.apply((int)player.getLastTimeSeen());
        }, (o1, o2) -> {
            long ao1 = o1.isOnline() ? 0L : o1.getLastTimeSeen();
            long ao2 = o2.isOnline() ? 0L : o2.getLastTimeSeen();
            return Long.compare(ao1, ao2);
        }, player -> player.getLastTimeSeen() != 0L).setRegistryName("ftbu:last_seen"));
    }

    private static double getDPH(IForgePlayer player) {
        double hours;
        int playTime = player.stats().func_77444_a(StatList.field_188097_g);
        if (playTime > 0 && (hours = (double)playTime / 72000.0) >= 1.0) {
            return (double)player.stats().func_77444_a(StatList.field_188069_A) / hours;
        }
        return -1.0;
    }
}

