/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.handlers;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrades;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.cmd.CmdShutdown;
import com.feed_the_beast.ftbu.util.FTBUPlayerData;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import com.feed_the_beast.ftbu.util.backups.Backups;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="ftbu")
public class FTBUWorldEventHandler {
    private static final ResourceLocation RESTART_TIMER_ID = FTBUFinals.get("restart_timer");
    public static final Function<ChunkDimPos, Boolean> ALLOW_EXPLOSION = pos -> {
        if (pos.dim == 0 && FTBUConfig.world.safe_spawn && FTBUUniverseData.isInSpawn(pos)) {
            return false;
        }
        if (FTBUConfig.world.enable_explosions.isDefault()) {
            ClaimedChunk chunk = ClaimedChunks.INSTANCE.getChunk((ChunkDimPos)pos);
            return chunk == null || !chunk.hasUpgrade(ChunkUpgrades.NO_EXPLOSIONS);
        }
        return FTBUConfig.world.enable_explosions.isTrue();
    };

    @SubscribeEvent
    public static void onMobSpawned(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && !FTBUWorldEventHandler.isEntityAllowed(event.getEntity())) {
            event.getEntity().func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerTickEvent(TickEvent.ServerTickEvent event) {
        if (!FTBLibAPI.API.hasUniverse()) {
            return;
        }
        MinecraftServer server = ServerUtils.getServer();
        long now = server.func_71218_a(0).func_82737_E();
        if (event.phase == TickEvent.Phase.START) {
            ClaimedChunks.INSTANCE.update(server, now);
        } else {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (player.field_71075_bZ.field_75098_d || !FTBUPlayerData.get((IForgePlayer)FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player)).fly) continue;
                boolean fly = player.field_71075_bZ.field_75101_c;
                player.field_71075_bZ.field_75101_c = true;
                if (fly) continue;
                player.func_71016_p();
            }
            if (FTBUUniverseData.shutdownTime > 0L) {
                long t = FTBUUniverseData.shutdownTime - now;
                if (t <= 0L) {
                    CmdShutdown.shutdown(ServerUtils.getServer());
                    return;
                }
                if (t == 200L && t % 20L == 0L || t == 1200L || t == 6000L || t == 12000L || t == 36000L) {
                    for (EntityPlayerMP player : ServerUtils.getPlayers()) {
                        Notification.of((ResourceLocation)RESTART_TIMER_ID, (ITextComponent[])new ITextComponent[]{StringUtils.color((ITextComponent)FTBULang.TIMER_SHUTDOWN.textComponent((ICommandSender)player, new Object[]{StringUtils.getTimeStringTicks((long)(t / 20L))}), (TextFormatting)TextFormatting.LIGHT_PURPLE)}).send((EntityPlayer)player);
                    }
                }
            }
            if (Backups.INSTANCE.nextBackup > 0L && Backups.INSTANCE.nextBackup <= now) {
                Backups.INSTANCE.run(server, (ICommandSender)server, "");
            }
            if (Backups.INSTANCE.thread != null && Backups.INSTANCE.thread.isDone) {
                Backups.INSTANCE.thread = null;
                Backups.INSTANCE.postBackup();
            }
        }
    }

    @SubscribeEvent
    public static void onDimensionUnload(WorldEvent.Unload event) {
        if (ClaimedChunks.INSTANCE != null) {
            ClaimedChunks.INSTANCE.markDirty();
        }
    }

    private static boolean isEntityAllowed(Entity entity) {
        if (entity instanceof EntityPlayer) {
            return true;
        }
        if (FTBUConfig.world.safe_spawn && FTBUUniverseData.isInSpawn(new ChunkDimPos(entity))) {
            if (entity instanceof IMob) {
                return false;
            }
            if (entity instanceof EntityChicken && !entity.func_184188_bt().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        if (world.field_72995_K || explosion.func_180343_e().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(explosion.func_180343_e());
        explosion.func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(pos, world.field_73011_w.getDimension()), ALLOW_EXPLOSION).booleanValue()) continue;
            explosion.func_180343_e().add(pos);
        }
    }
}

