/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.integration;

import com.feed_the_beast.ftbl.lib.client.ClientUtils;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.client.FTBUClientConfig;
import com.feed_the_beast.ftbu.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbu.gui.UpdateClientDataEvent;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksRequest;
import com.feed_the_beast.ftbu.net.MessageClaimedChunksUpdate;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import journeymap.client.api.ClientPlugin;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.util.PolygonHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@ClientPlugin
public class JMIntegration
implements IClientPlugin {
    private static IClientAPI clientAPI;
    private static final Map<ChunkPos, PolygonOverlay> POLYGONS;
    static ChunkPos lastPosition;

    public void initialize(IClientAPI api) {
        clientAPI = api;
        api.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.DISPLAY_UPDATE, ClientEvent.Type.MAPPING_STOPPED));
        MinecraftForge.EVENT_BUS.register(JMIntegration.class);
    }

    public String getModId() {
        return "ftbu";
    }

    public void onEvent(ClientEvent event) {
        switch (event.type) {
            case DISPLAY_UPDATE: {
                if (ClientUtils.MC.field_71439_g == null) break;
                new MessageClaimedChunksRequest((Entity)ClientUtils.MC.field_71439_g).sendToServer();
                break;
            }
            case MAPPING_STOPPED: {
                JMIntegration.clearData();
            }
        }
    }

    private static void clearData() {
        if (!POLYGONS.isEmpty()) {
            POLYGONS.clear();
            clientAPI.removeAll("ftbu");
        }
    }

    static void chunkChanged(ChunkPos pos, @Nullable ClientClaimedChunks.ChunkData chunk) {
        if (!(POLYGONS.isEmpty() || FTBUClientConfig.general.journeymap_overlay && clientAPI.playerAccepts("ftbu", DisplayType.Polygon))) {
            JMIntegration.clearData();
            return;
        }
        try {
            PolygonOverlay p = POLYGONS.get(pos);
            if (p != null) {
                clientAPI.remove((Displayable)p);
                if (chunk == null) {
                    POLYGONS.remove(pos);
                }
            }
            if (chunk != null) {
                int dim = 0;
                MapPolygon poly = PolygonHelper.createChunkPolygon((int)pos.field_77276_a, (int)0, (int)pos.field_77275_b);
                ShapeProperties shapeProperties = new ShapeProperties();
                shapeProperties.setFillOpacity(0.2f);
                shapeProperties.setStrokeOpacity(0.0f);
                shapeProperties.setFillColor(chunk.team.color.getColor().rgba());
                p = new PolygonOverlay("ftbu", "claimed_" + pos.field_77276_a + '_' + pos.field_77275_b, dim, shapeProperties, poly);
                p.setOverlayGroupName("claimed_chunks").setTitle(chunk.team.formattedName + '\n' + TextFormatting.GREEN + FTBULang.CHUNKS_CLAIMED_AREA.translate());
                POLYGONS.put(pos, p);
                clientAPI.show((Displayable)p);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onEnteringChunk(EntityEvent.EnteringChunk event) {
        if (!FTBUClientConfig.general.journeymap_overlay || event.getEntity() != ClientUtils.MC.field_71439_g) {
            return;
        }
        if (lastPosition == null || MathUtils.dist((double)event.getNewChunkX(), (double)event.getNewChunkZ(), (double)JMIntegration.lastPosition.field_77276_a, (double)JMIntegration.lastPosition.field_77275_b) >= 3.0) {
            lastPosition = new ChunkPos(event.getNewChunkX(), event.getNewChunkZ());
            new MessageClaimedChunksRequest((Entity)ClientUtils.MC.field_71439_g).sendToServer();
        }
    }

    @SubscribeEvent
    public static void onDataReceived(UpdateClientDataEvent event) {
        MessageClaimedChunksUpdate m = event.getMessage();
        ClientClaimedChunks.ChunkData[] data = new ClientClaimedChunks.ChunkData[225];
        for (ClientClaimedChunks.Team team : m.teams.values()) {
            for (Map.Entry<Integer, ClientClaimedChunks.ChunkData> entry : team.chunks.entrySet()) {
                int x = entry.getKey() % 15;
                int z = entry.getKey() / 15;
                data[x + z * 15] = entry.getValue();
            }
        }
        for (int z = 0; z < 15; ++z) {
            for (int x = 0; x < 15; ++x) {
                JMIntegration.chunkChanged(new ChunkPos(m.startX + x, m.startZ + z), data[x + z * 15]);
            }
        }
    }

    static {
        POLYGONS = new HashMap<ChunkPos, PolygonOverlay>();
        lastPosition = null;
    }
}

