/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.integration;

import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.lib.icon.Icon;
import com.feed_the_beast.ftbl.lib.icon.IconAnimation;
import com.feed_the_beast.ftbl.lib.icon.ItemIcon;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.api.guide.ClientGuideEvent;
import com.feed_the_beast.ftbu.api.guide.IGuidePage;
import com.feed_the_beast.ftbu.api.guide.IGuideTitlePage;
import com.feed_the_beast.ftbu.gui.guide.GuideContentsLine;
import com.feed_the_beast.ftbu.gui.guide.GuideExtendedTextLine;
import com.feed_the_beast.ftbu.gui.guide.GuideHrLine;
import com.feed_the_beast.ftbu.gui.guide.GuidePage;
import com.feed_the_beast.ftbu.gui.guide.IconAnimationLine;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResource;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.TinkerMaterials;

@GameRegistry.ObjectHolder(value="tconstruct")
@EventHandler(value={Side.CLIENT}, requiredMods={"tconstruct"})
public class TiCIntegration {
    @SubscribeEvent
    public static void onGuideEvent(ClientGuideEvent event) {
        IGuideTitlePage page = event.getModGuide("tconstruct");
        page.setIcon(ItemIcon.getItemIcon((String)"tconstruct:toolforge"));
        page.println(new GuideHrLine(1, Icon.EMPTY));
        page.println(new GuideContentsLine(page));
        IGuidePage pageIntro = TiCIntegration.loadPage(event, "intro", page);
        if (pageIntro != null) {
            pageIntro.setTitle((ITextComponent)new TextComponentString("Introduction"));
            pageIntro.setIcon(ItemIcon.getItemIcon((String)"tconstruct:tooltables"));
            page.addSub(pageIntro);
        }
        IGuidePage toolMaterials = page.getSub("materials");
        toolMaterials.setTitle((ITextComponent)new TextComponentString("Materials"));
        toolMaterials.setIcon(ItemIcon.getItemIcon((ItemStack)new ItemStack(Items.field_151035_b)));
        ImmutableList mats = ImmutableList.of((Object)TinkerMaterials.wood, (Object)TinkerMaterials.cobalt, (Object)TinkerMaterials.ardite, (Object)TinkerMaterials.manyullyn);
        for (Object material : TinkerRegistry.getAllMaterials()) {
            if (material.isHidden() || !material.hasItems()) continue;
            IGuidePage page1 = toolMaterials.getSub(material.getIdentifier());
            page1.setIcon(ItemIcon.getItemIcon((ItemStack)material.getRepresentativeItem()));
            page1.setTitle((ITextComponent)new TextComponentString(material.getLocalizedName()));
            for (IMaterialStats stats : material.getAllStats()) {
                TextComponentString component = new TextComponentString(stats.getLocalizedName());
                component.func_150256_b().func_150228_d(Boolean.valueOf(true));
                page1.println(component);
                IconAnimation parts = new IconAnimation(Collections.emptyList());
                for (IToolPart part : TinkerRegistry.getToolParts()) {
                    if (!part.hasUseForStat(stats.getIdentifier())) continue;
                    parts.list.add(ItemIcon.getItemIcon((ItemStack)part.getItemstackWithMaterial((Material)material)));
                }
                if (parts.list.size() > 0) {
                    page1.println(new IconAnimationLine(parts, 8));
                }
                for (int i = 0; i < stats.getLocalizedInfo().size(); ++i) {
                    TextComponentString component1 = new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedInfo().get(i)));
                    component1.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentString(TiCIntegration.transformString((String)stats.getLocalizedDesc().get(i)))));
                    page1.println(new GuideExtendedTextLine((ITextComponent)component1));
                }
                page1.println(null);
            }
        }
        IGuidePage modifiers = page.getSub("modifiers");
        modifiers.setTitle((ITextComponent)new TextComponentString("Modifiers"));
        modifiers.setIcon(ItemIcon.getItemIcon((ItemStack)new ItemStack(Items.field_151137_ax)));
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            if (modifier.isHidden() || !modifier.hasItemsToApplyWith()) continue;
            try {
                IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/modifiers/" + modifier.getIdentifier() + ".json"));
                JsonElement json = JsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
                if (!json.isJsonObject()) continue;
                JsonObject o = json.getAsJsonObject();
                IGuidePage page1 = modifiers.getSub(modifier.getIdentifier());
                page1.setTitle((ITextComponent)new TextComponentString(modifier.getLocalizedName()));
                page1.println(TiCIntegration.transformString(modifier.getLocalizedDesc()));
                IconAnimation displayItems = new IconAnimation(Collections.emptyList());
                if (o.has("text")) {
                    page1.println(null);
                    for (JsonElement e : o.get("text").getAsJsonArray()) {
                        page1.println(JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (o.has("effects")) {
                    page1.println(null);
                    page1.println("Effects:");
                    for (JsonElement e : o.get("effects").getAsJsonArray()) {
                        page1.println(JsonUtils.deserializeTextComponent((JsonElement)e));
                    }
                }
                if (!o.has("demoTool")) continue;
                for (JsonElement e : o.get("demoTool").getAsJsonArray()) {
                    Item item = Item.func_111206_d((String)e.getAsString());
                    if (!(item instanceof ToolCore)) continue;
                    displayItems.list.add(ItemIcon.getItemIcon((ItemStack)((ToolCore)item).buildItemForRendering((List)mats.subList(0, ((ToolCore)item).getRequiredComponents().size()))));
                }
                if (displayItems.list.isEmpty()) continue;
                page1.println(null);
                page1.println(new IconAnimationLine(displayItems, 8));
            }
            catch (Exception exception) {}
        }
        modifiers.sort(false);
        IGuidePage pageSmeltry = TiCIntegration.loadPage(event, "smeltery", page);
        if (pageSmeltry != null) {
            pageSmeltry.setTitle((ITextComponent)new TextComponentString("Smeltry"));
            pageSmeltry.setIcon(ItemIcon.getItemIcon((String)"tconstruct:toolstation"));
            page.addSub(pageSmeltry);
        }
    }

    private static String transformString(String s) {
        return StringUtils.trimAllWhitespace((String)s.replace("\\n", "\n"));
    }

    @Nullable
    private static IGuidePage loadPage(ClientGuideEvent event, String id, IGuidePage p) {
        try {
            IResource resource = event.getResourceManager().func_110536_a(new ResourceLocation("tconstruct", "book/en_US/sections/" + id + ".json"));
            JsonElement json = JsonUtils.fromJson((Reader)new InputStreamReader(resource.func_110527_b()));
            if (json.isJsonArray()) {
                GuidePage page = new GuidePage(id, p);
                for (JsonElement jsonElement : json.getAsJsonArray()) {
                }
                return page;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

