/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.internal.FTBLibNotifications;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.net.MessageToServer;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.util.FTBUTeamData;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.server.permission.PermissionAPI;

public class MessageClaimedChunksModify
extends MessageToServer<MessageClaimedChunksModify> {
    public static final int CLAIM = 0;
    public static final int UNCLAIM = 1;
    public static final int LOAD = 2;
    public static final int UNLOAD = 3;
    private int startX;
    private int startZ;
    private int action;
    private Collection<ChunkPos> chunks;

    public MessageClaimedChunksModify() {
    }

    public MessageClaimedChunksModify(int sx, int sz, int a, Collection<ChunkPos> c) {
        this.startX = sx;
        this.startZ = sz;
        this.action = a;
        this.chunks = c;
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.CLAIMS;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.startX);
        data.writeInt(this.startZ);
        data.writeByte(this.action);
        data.writeCollection(this.chunks, DataOut.CHUNK_POS);
    }

    public void readData(DataIn data) {
        this.startX = data.readInt();
        this.startZ = data.readInt();
        this.action = data.readUnsignedByte();
        this.chunks = data.readCollection(null, DataIn.CHUNK_POS);
    }

    public void onMessage(MessageClaimedChunksModify m, EntityPlayer player) {
        IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player);
        if (!FTBUConfig.world.chunk_claiming) {
            return;
        }
        IForgeTeam team = p.getTeam();
        if (team == null) {
            FTBLibNotifications.NO_TEAM.send(player);
            return;
        }
        boolean canUnclaim = m.action == 1 && PermissionAPI.hasPermission((GameProfile)player.func_146103_bH(), (String)"ftbu.claims.modify.others", null);
        for (ChunkPos pos0 : m.chunks) {
            ChunkDimPos pos = new ChunkDimPos(pos0, player.field_71093_bK);
            switch (m.action) {
                case 0: {
                    ClaimedChunks.INSTANCE.claimChunk(FTBUTeamData.get(team), pos);
                    break;
                }
                case 1: {
                    if (!canUnclaim && !team.equalsTeam(ClaimedChunks.INSTANCE.getChunkTeam(pos))) break;
                    ClaimedChunks.INSTANCE.unclaimChunk(team, pos);
                    break;
                }
                case 2: {
                    ClaimedChunks.INSTANCE.setLoaded(team, pos, true);
                    break;
                }
                case 3: {
                    ClaimedChunks.INSTANCE.setLoaded(team, pos, false);
                }
            }
        }
    }
}

