/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.api.chunks.IClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ChunkUpgrades;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.gui.ClientClaimedChunks;
import com.feed_the_beast.ftbu.gui.UpdateClientDataEvent;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.util.FTBUTeamData;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.server.permission.PermissionAPI;

public class MessageClaimedChunksUpdate
extends MessageToClient<MessageClaimedChunksUpdate> {
    public int startX;
    public int startZ;
    public int claimedChunks;
    public int loadedChunks;
    public int maxClaimedChunks;
    public int maxLoadedChunks;
    public Map<UUID, ClientClaimedChunks.Team> teams;

    public MessageClaimedChunksUpdate() {
    }

    public MessageClaimedChunksUpdate(int sx, int sz, EntityPlayer player) {
        this.startX = sx;
        this.startZ = sz;
        IForgePlayer p = FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player);
        FTBUTeamData teamData = p.getTeam() == null ? null : FTBUTeamData.get(p.getTeam());
        List<IClaimedChunk> chunks = teamData != null ? ClaimedChunks.INSTANCE.getTeamChunks(teamData.team) : Collections.emptyList();
        this.claimedChunks = chunks.size();
        this.loadedChunks = 0;
        for (IClaimedChunk c : chunks) {
            if (!c.hasUpgrade(ChunkUpgrades.LOADED)) continue;
            ++this.loadedChunks;
        }
        this.maxClaimedChunks = teamData == null ? 0 : teamData.getMaxClaimChunks();
        this.maxLoadedChunks = teamData == null ? 0 : teamData.getMaxChunkloaderChunks();
        this.teams = new HashMap<UUID, ClientClaimedChunks.Team>();
        boolean canSeeChunkInfo = PermissionAPI.hasPermission((EntityPlayer)player, (String)"ftbu.claims.modify.others");
        for (int x1 = 0; x1 < 15; ++x1) {
            for (int z1 = 0; z1 < 15; ++z1) {
                ChunkDimPos pos = new ChunkDimPos(this.startX + x1, this.startZ + z1, player.field_71093_bK);
                ClaimedChunk chunk = ClaimedChunks.INSTANCE.getChunk(pos);
                if (chunk == null) continue;
                IForgeTeam chunkTeam = chunk.getTeam();
                ClientClaimedChunks.Team team = this.teams.get(chunkTeam.getOwner().getId());
                if (team == null) {
                    team = new ClientClaimedChunks.Team(chunkTeam.getOwner().getId());
                    team.color = chunkTeam.getColor();
                    team.formattedName = chunkTeam.getColor().getTextFormatting() + chunkTeam.getTitle();
                    team.isAlly = chunkTeam.isAlly(p);
                    this.teams.put(team.ownerId, team);
                }
                ClientClaimedChunks.ChunkData data = new ClientClaimedChunks.ChunkData(team);
                boolean member = chunkTeam.isMember(p);
                if (canSeeChunkInfo || member) {
                    for (ChunkUpgrade upgrade : FTBUUniverseData.CHUNK_UPGRADES.values()) {
                        if (!chunk.hasUpgrade(upgrade)) continue;
                        data.setHasUpgrade(upgrade, true);
                    }
                }
                team.chunks.put(x1 + z1 * 15, data);
            }
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.CLAIMS;
    }

    public void writeData(DataOut data) {
        data.writeInt(this.startX);
        data.writeInt(this.startZ);
        data.writeInt(this.claimedChunks);
        data.writeInt(this.loadedChunks);
        data.writeInt(this.maxClaimedChunks);
        data.writeInt(this.maxLoadedChunks);
        data.writeCollection(this.teams.values(), ClientClaimedChunks.Team.SERIALIZER);
    }

    public void readData(DataIn data) {
        this.startX = data.readInt();
        this.startZ = data.readInt();
        this.claimedChunks = data.readInt();
        this.loadedChunks = data.readInt();
        this.maxClaimedChunks = data.readInt();
        this.maxLoadedChunks = data.readInt();
        this.teams = new HashMap<UUID, ClientClaimedChunks.Team>();
        for (ClientClaimedChunks.Team team : data.readCollection(ClientClaimedChunks.Team.DESERIALIZER)) {
            this.teams.put(team.ownerId, team);
        }
    }

    public void onMessage(MessageClaimedChunksUpdate m, EntityPlayer player) {
        new UpdateClientDataEvent(m).post();
    }
}

