/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToServer;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.net.MessageSendBadge;
import com.feed_the_beast.ftbu.util.Badges;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class MessageRequestBadge
extends MessageToServer<MessageRequestBadge> {
    private UUID playerId;

    public MessageRequestBadge() {
    }

    public MessageRequestBadge(UUID player) {
        this.playerId = player;
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.BADGES;
    }

    public void writeData(DataOut data) {
        data.writeUUID(this.playerId);
    }

    public void readData(DataIn data) {
        this.playerId = data.readUUID();
    }

    public void onMessage(MessageRequestBadge m, EntityPlayer player) {
        new ThreadBadge(m.playerId, player).start();
    }

    private static class ThreadBadge
    extends Thread {
        private final UUID playerId;
        private final EntityPlayer player;

        private ThreadBadge(UUID id, EntityPlayer p) {
            super("Badge_" + StringUtils.fromUUID((UUID)id));
            this.playerId = id;
            this.player = p;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            new MessageSendBadge(this.playerId, Badges.get(this.playerId)).sendTo(this.player);
        }
    }
}

