/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbu.api.Leaderboard;
import com.feed_the_beast.ftbu.api.LeaderboardValue;
import com.feed_the_beast.ftbu.gui.GuiLeaderboard;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class MessageSendLeaderboard
extends MessageToClient<MessageSendLeaderboard> {
    private static final DataOut.Serializer<LeaderboardValue> VALUE_SERIALIZER = (data, object) -> {
        data.writeString(object.username);
        data.writeTextComponent(object.value);
        data.writeByte(object.color.ordinal());
    };
    private static final DataIn.Deserializer<LeaderboardValue> VALUE_DESERIALIZER = data -> {
        LeaderboardValue value = new LeaderboardValue();
        value.username = data.readString();
        value.value = data.readTextComponent();
        value.color = TextFormatting.values()[data.readUnsignedByte()];
        return value;
    };
    private ITextComponent title;
    private List<LeaderboardValue> values;

    public MessageSendLeaderboard() {
    }

    public MessageSendLeaderboard(EntityPlayerMP player, Leaderboard leaderboard) {
        this.title = leaderboard.getTitle();
        this.values = new ArrayList<LeaderboardValue>();
        IForgePlayer p0 = FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player);
        List players = FTBLibAPI.API.getUniverse().getRealPlayers();
        players.sort(leaderboard.getComparator());
        for (int i = 0; i < players.size(); ++i) {
            IForgePlayer p = (IForgePlayer)players.get(i);
            LeaderboardValue value = new LeaderboardValue();
            value.username = p.func_176610_l();
            value.value = leaderboard.createValue(p);
            value.color = p == p0 ? TextFormatting.DARK_GREEN : (!leaderboard.hasValidValue(p) ? TextFormatting.DARK_GRAY : (i < 3 ? TextFormatting.GOLD : TextFormatting.RESET));
            this.values.add(value);
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.LEADERBOARDS;
    }

    public void writeData(DataOut data) {
        data.writeTextComponent(this.title);
        data.writeCollection(this.values, VALUE_SERIALIZER);
    }

    public void readData(DataIn data) {
        this.title = data.readTextComponent();
        this.values = new ArrayList<LeaderboardValue>();
        data.readCollection(this.values, VALUE_DESERIALIZER);
    }

    public void onMessage(MessageSendLeaderboard m, EntityPlayer player) {
        new GuiLeaderboard(m.title, m.values).openGui();
    }
}

