/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbu.gui.GuiWarps;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.feed_the_beast.ftbu.util.FTBUPlayerData;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class MessageSendWarpList
extends MessageToClient<MessageSendWarpList> {
    private List<WarpItem> warps;

    public MessageSendWarpList() {
    }

    private static String command(EntityPlayerMP player, String name, String backup) {
        ICommand command = (ICommand)player.field_71133_b.func_71187_D().func_71555_a().get(name);
        return "/" + (command != null && command.func_184882_a(player.field_71133_b, (ICommandSender)player) ? name : backup);
    }

    public MessageSendWarpList(EntityPlayerMP player) {
        this.warps = new ArrayList<WarpItem>();
        this.warps.add(new WarpItem("Spawn", MessageSendWarpList.command(player, "spawn", "ftb spawn"), 1));
        this.warps.add(new WarpItem("Back", MessageSendWarpList.command(player, "back", "ftb back"), 0));
        String cmd = MessageSendWarpList.command(player, "warp", "ftb warp") + " ";
        for (String s : FTBUUniverseData.WARPS.list()) {
            this.warps.add(new WarpItem(s, cmd + s, 2));
        }
        cmd = MessageSendWarpList.command(player, "home", "ftb home") + " ";
        for (String s : FTBUPlayerData.get((IForgePlayer)FTBLibAPI.API.getUniverse().getPlayer((ICommandSender)player)).homes.list()) {
            this.warps.add(new WarpItem(s, cmd + s, 3));
        }
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeCollection(this.warps, WarpItem.SERIALIZER);
    }

    public void readData(DataIn data) {
        this.warps = new ArrayList<WarpItem>();
        data.readCollection(this.warps, WarpItem.DESERIALIZER);
    }

    public void onMessage(MessageSendWarpList m, EntityPlayer player) {
        if (GuiWarps.INSTANCE != null) {
            GuiWarps.INSTANCE.setData(m.warps);
        }
    }

    public static class WarpItem
    implements Comparable<WarpItem> {
        public static final int TYPE_SPECIAL_IN = 0;
        public static final int TYPE_SPECIAL_OUT = 1;
        public static final int TYPE_WARP = 2;
        public static final int TYPE_HOME = 3;
        public static final WarpItem CANCEL = new WarpItem("Cancel", "", 0);
        private static final DataOut.Serializer<WarpItem> SERIALIZER = (data, w) -> {
            data.writeString(w.name);
            data.writeString(w.cmd);
            data.writeByte(w.type);
        };
        private static final DataIn.Deserializer<WarpItem> DESERIALIZER = data -> {
            String n = data.readString();
            String c = data.readString();
            return new WarpItem(n, c, data.readUnsignedByte());
        };
        public final String name;
        public final String cmd;
        public final int type;

        private WarpItem(String n, String c, int t) {
            this.name = n;
            this.cmd = c;
            this.type = t;
        }

        public boolean isSpecial() {
            return this.type == 0 || this.type == 1;
        }

        public boolean innerCircle() {
            return this.type == 0 || this.type == 3;
        }

        @Override
        public int compareTo(WarpItem o) {
            return this.name.compareToIgnoreCase(o.name);
        }
    }
}

