/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.net;

import com.feed_the_beast.ftbl.lib.io.DataIn;
import com.feed_the_beast.ftbl.lib.io.DataOut;
import com.feed_the_beast.ftbl.lib.net.MessageToClient;
import com.feed_the_beast.ftbl.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbu.ServerInfoPage;
import com.feed_the_beast.ftbu.api.guide.ServerInfoEvent;
import com.feed_the_beast.ftbu.gui.guide.Guides;
import com.feed_the_beast.ftbu.net.FTBUNetHandler;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;

public class MessageServerInfo
extends MessageToClient<MessageServerInfo> {
    public JsonArray mainPage;
    public CommandInfo commands;
    public JsonElement serverGuide;

    public MessageServerInfo() {
    }

    public MessageServerInfo(EntityPlayerMP player) {
        long now = player.func_130014_f_().func_82737_E();
        List<ITextComponent> list = ServerInfoPage.getMainPage(player, now);
        new ServerInfoEvent(player, now, list::add).post();
        this.mainPage = new JsonArray();
        for (ITextComponent component : list) {
            this.mainPage.add(JsonUtils.serializeTextComponent((ITextComponent)component));
        }
        this.commands = ServerInfoPage.getCommands(player);
        this.serverGuide = ServerInfoPage.getServerGuide();
    }

    public NetworkWrapper getWrapper() {
        return FTBUNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeJson((JsonElement)this.mainPage);
        data.write(CommandInfo.SERIALIZER, (Object)this.commands);
        data.writeJson(this.serverGuide);
    }

    public void readData(DataIn data) {
        this.mainPage = data.readJson().getAsJsonArray();
        this.commands = (CommandInfo)data.read(CommandInfo.DESERIALIZER);
        this.serverGuide = data.readJson();
    }

    public void onMessage(MessageServerInfo m, EntityPlayer player) {
        Guides.readServerInfoPage(m);
    }

    public static class CommandInfo {
        private static final DataOut.Serializer<CommandInfo> SERIALIZER = (data, object) -> object.writeData(data);
        private static final DataIn.Deserializer<CommandInfo> DESERIALIZER = CommandInfo::new;
        public final String name;
        public final Collection<ITextComponent> info;
        public final Collection<CommandInfo> subcommands;

        private CommandInfo(DataIn data) {
            this.name = data.readString();
            this.info = data.readCollection(DataIn.TEXT_COMPONENT);
            this.subcommands = data.readCollection(null, DESERIALIZER);
        }

        public CommandInfo(String n, Collection<ITextComponent> t, Collection<CommandInfo> c) {
            this.name = n;
            this.info = t;
            this.subcommands = c;
        }

        public void writeData(DataOut data) {
            data.writeString(this.name);
            data.writeCollection(this.info, DataOut.TEXT_COMPONENT);
            data.writeCollection(this.subcommands, SERIALIZER);
        }
    }
}

