/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.ranks;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.lib.config.ConfigValueInfo;
import com.feed_the_beast.ftbl.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBUCommon;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBUtilitiesAPI;
import com.feed_the_beast.ftbu.api.IRank;
import com.feed_the_beast.ftbu.api.NodeEntry;
import com.feed_the_beast.ftbu.ranks.DefaultOPRank;
import com.feed_the_beast.ftbu.ranks.DefaultPlayerRank;
import com.feed_the_beast.ftbu.ranks.Rank;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class Ranks {
    private static final Map<String, Rank> RANKS = new LinkedHashMap<String, Rank>();
    private static final Collection<String> RANK_NAMES = new ArrayList<String>();
    private static final Map<UUID, IRank> PLAYER_MAP = new HashMap<UUID, IRank>();
    private static IRank defaultPlayerRank;
    private static IRank defaultOPRank;
    public static final Collection<String> CMD_PERMISSION_NODES;

    @Nullable
    public static IRank getRank(String id, @Nullable IRank nullrank) {
        if (id.equals(DefaultPlayerRank.INSTANCE.func_176610_l())) {
            return DefaultPlayerRank.INSTANCE;
        }
        if (id.equals(DefaultOPRank.INSTANCE.func_176610_l())) {
            return DefaultOPRank.INSTANCE;
        }
        IRank r = RANKS.get(id);
        return r == null ? nullrank : r;
    }

    public static IRank getDefaultPlayerRank() {
        if (defaultPlayerRank == null) {
            Rank r = new Rank("player");
            r.parent = DefaultPlayerRank.INSTANCE;
            RANKS.put(r.func_176610_l(), r);
            defaultPlayerRank = r;
        }
        return defaultPlayerRank;
    }

    public static IRank getDefaultOPRank() {
        if (defaultOPRank == null) {
            Rank r = new Rank("op");
            r.parent = DefaultOPRank.INSTANCE;
            r.syntax = "<" + TextFormatting.DARK_GREEN + "$name" + TextFormatting.RESET + "> ";
            RANKS.put(r.func_176610_l(), r);
            defaultOPRank = r;
        }
        return defaultOPRank;
    }

    public static IRank getRank(GameProfile profile) {
        IRank r;
        IRank iRank = r = FTBUConfig.ranks.enabled ? PLAYER_MAP.get(profile.getId()) : null;
        return r == null ? (ServerUtils.isOP((GameProfile)profile) ? Ranks.getDefaultOPRank() : Ranks.getDefaultPlayerRank()) : r;
    }

    public static void addRank(Rank rank) {
        RANKS.put(rank.func_176610_l(), rank);
        Ranks.updateRankNames();
        Ranks.saveRanks();
    }

    public static void setRank(UUID id, @Nullable IRank r) {
        if (r == null) {
            PLAYER_MAP.remove(id);
        } else {
            PLAYER_MAP.put(id, r);
        }
        Ranks.saveRanks();
    }

    public static Collection<String> getRankNames() {
        return RANK_NAMES;
    }

    public static void updateRankNames() {
        RANK_NAMES.clear();
        RANK_NAMES.addAll(RANKS.keySet());
        RANK_NAMES.add("none");
        RANK_NAMES.remove(DefaultPlayerRank.INSTANCE.func_176610_l());
        RANK_NAMES.remove(DefaultOPRank.INSTANCE.func_176610_l());
    }

    public static boolean reload() {
        FTBUFinals.LOGGER.info("Loading ranks..");
        RANKS.clear();
        RANKS.put(DefaultPlayerRank.INSTANCE.func_176610_l(), DefaultPlayerRank.INSTANCE);
        RANKS.put(DefaultOPRank.INSTANCE.func_176610_l(), DefaultOPRank.INSTANCE);
        PLAYER_MAP.clear();
        defaultPlayerRank = null;
        defaultOPRank = null;
        boolean result = true;
        if (FTBUConfig.ranks.enabled) {
            Object o;
            JsonElement e = JsonUtils.fromJson((File)new File(CommonUtils.folderLocal, "ftbutilities/ranks.json"));
            if (e.isJsonObject() && (o = e.getAsJsonObject()).has("default_ranks") && o.has("ranks")) {
                for (Map.Entry entry : o.get("ranks").getAsJsonObject().entrySet()) {
                    RANKS.put((String)entry.getKey(), new Rank((String)entry.getKey()));
                }
                for (Map.Entry entry : o.get("ranks").getAsJsonObject().entrySet()) {
                    RANKS.get(entry.getKey()).func_152753_a((JsonElement)entry.getValue());
                }
                JsonObject dr = o.get("default_ranks").getAsJsonObject();
                defaultPlayerRank = dr.has("player") ? (IRank)RANKS.get(dr.get("player").getAsString()) : null;
                defaultOPRank = dr.has("op") ? (IRank)RANKS.get(dr.get("op").getAsString()) : null;
            }
            try {
                e = JsonUtils.fromJson((File)new File(CommonUtils.folderLocal, "ftbutilities/player_ranks.json"));
                if (e.isJsonObject()) {
                    for (Map.Entry entry : e.getAsJsonObject().entrySet()) {
                        String s;
                        UUID id = StringUtils.fromString((String)((String)entry.getKey()));
                        if (id == null || !RANKS.containsKey(s = ((JsonElement)entry.getValue()).getAsString())) continue;
                        PLAYER_MAP.put(id, RANKS.get(s));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result = false;
            }
        }
        Ranks.updateRankNames();
        Ranks.saveRanks();
        return result;
    }

    private static void saveRanks() {
        JsonObject o = new JsonObject();
        JsonObject o1 = new JsonObject();
        o1.addProperty("player", Ranks.getDefaultPlayerRank().func_176610_l());
        o1.addProperty("op", Ranks.getDefaultOPRank().func_176610_l());
        o.add("default_ranks", (JsonElement)o1);
        o1 = new JsonObject();
        for (Rank r : RANKS.values()) {
            JsonElement e = r.func_151003_a();
            if (e.isJsonNull()) continue;
            o1.add(r.func_176610_l(), e);
        }
        o.add("ranks", (JsonElement)o1);
        JsonUtils.toJson((JsonElement)o, (File)new File(CommonUtils.folderLocal, "ftbutilities/ranks.json"));
        JsonObject o2 = new JsonObject();
        PLAYER_MAP.forEach((key, value) -> o2.add(StringUtils.fromUUID((UUID)key), (JsonElement)new JsonPrimitive(value.func_176610_l())));
        JsonUtils.toJson((JsonElement)o2, (File)new File(CommonUtils.folderLocal, "ftbutilities/player_ranks.json"));
    }

    static boolean checkCommandPermission(MinecraftServer server, ICommandSender sender, ICommand parent, String permission) {
        if (sender instanceof EntityPlayerMP) {
            Event.Result result = FTBUtilitiesAPI.API.getRank(((EntityPlayerMP)sender).func_146103_bH()).hasPermission(permission);
            return result == Event.Result.DEFAULT ? parent.func_184882_a(server, sender) : result == Event.Result.ALLOW;
        }
        return parent.func_184882_a(server, sender);
    }

    public static void generateExampleFiles() {
        ArrayList<NodeEntry> allNodes = new ArrayList<NodeEntry>();
        for (NodeEntry node : FTBUCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
            allNodes.add(new NodeEntry(node.func_176610_l() + "*", node.getLevel(), node.getDescription()));
        }
        for (Object s : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
            DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel((String)s);
            String desc = PermissionAPI.getPermissionHandler().getNodeDescription((String)s);
            int printNode = 1;
            for (NodeEntry nodeEntry : FTBUCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                if (!((String)s).startsWith(nodeEntry.func_176610_l())) continue;
                if (level != nodeEntry.getLevel() || !desc.isEmpty()) break;
                printNode = 0;
                break;
            }
            if (printNode == 0) continue;
            allNodes.add(new NodeEntry((String)s, level, desc));
        }
        allNodes.sort(StringUtils.ID_COMPARATOR);
        ArrayList<String> list = new ArrayList<String>();
        try {
            list.add("<html><head><title>Permissions</title><style>");
            list.add("table{font-family:arial, sans-serif;border-collapse:collapse;}");
            list.add("td,th{border:1px solid #666666;text-align:left;padding:8px;}");
            list.add("td.all{background-color:#72FF85;}");
            list.add("td.op{background-color:#42A3FF;}");
            list.add("td.none{background-color:#FF4242;}");
            list.add("</style></head><body><h1>Permissions</h1><h3>Modifying this file won't have any effect!</h3><table>");
            list.add("<tr><th>Permission Node</th><th></th><th>Info</th></tr>");
            for (NodeEntry entry : allNodes) {
                list.add("<tr><td>" + entry.func_176610_l() + "</td><td class='" + entry.getLevel().name().toLowerCase() + "'>" + entry.getLevel() + "</td><td>");
                if (entry.getDescription() != null) {
                    for (String string : entry.getDescription().split("\n")) {
                        list.add("<p>" + string + "</p>");
                    }
                }
                list.add("</td></tr>");
            }
            list.add("</table></body></html>");
            FileUtils.save((File)new File(CommonUtils.folderLocal, "ftbutilities/all_permissions.html"), list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList sortedRankConfigKeys = new ArrayList(FTBLibAPI.API.getRankConfigRegistry().values());
        sortedRankConfigKeys.sort(StringUtils.ID_COMPARATOR);
        try {
            list.clear();
            list.add("<html><head><title>Rank Configs</title>");
            list.add("<style>table{font-family: arial, sans-serif;border-collapse: collapse;}td,th{border:1px solid #666666;text-align: left;padding:8px;}p,ul{margin:4px;}</style>");
            list.add("</head><body><h1>Rank Configs</h1><h3>Modifying this file won't have any effect!</h3><table>");
            list.add("<tr><th>Rank Config</th><th>Def Value</th><th>Info</th></tr>");
            ArrayList infoList = new ArrayList();
            for (RankConfigValueInfo p : sortedRankConfigKeys) {
                list.add("<tr><td>" + p.id + "</td><td>");
                p.defaultValue.addInfo((ConfigValueInfo)p, infoList);
                ArrayList variants = p.defaultValue.getVariants();
                if (!infoList.isEmpty() || !variants.isEmpty()) {
                    list.add("<ul><li>Default: " + p.defaultValue.func_151003_a() + "</li>");
                    list.add("<li>OP Default: " + p.defaultOPValue.func_151003_a() + "</li>");
                    for (String s : infoList) {
                        if (s.contains("Def:")) continue;
                        list.add("<li>" + TextFormatting.func_110646_a((String)s) + "</li>");
                    }
                    infoList.clear();
                    if (!variants.isEmpty()) {
                        list.add("<li>Variants:<ul>");
                        variants = new ArrayList(variants);
                        variants.sort(StringUtils.IGNORE_CASE_COMPARATOR);
                        for (String s : variants) {
                            list.add("<li>" + s + "</li>");
                        }
                        list.add("</ul></li>");
                    }
                    list.add("</ul>");
                } else {
                    list.add("Default: " + p.defaultValue.func_151003_a());
                }
                list.add("</td><td>");
                String string = StringUtils.translate((String)(p.displayName.isEmpty() ? "rank_config." + p.id : p.displayName));
                if (!string.isEmpty()) {
                    for (String s1 : string.split("\\\\n")) {
                        list.add("<p>" + s1 + "</p>");
                    }
                }
                list.add("</td></tr>");
            }
            list.add("</table></body></html>");
            FileUtils.save((File)new File(CommonUtils.folderLocal, "ftbutilities/all_configs.html"), list);
            list.clear();
            for (String node : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
                list.add(node + ": " + DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node));
            }
            list.addAll(CMD_PERMISSION_NODES);
            Collections.sort(list);
            list.add(0, "");
            list.add(0, "Modifying this file won't have any effect!");
            list.add(0, PermissionAPI.getPermissionHandler().getRegisteredNodes().size() + " nodes in total");
            FileUtils.save((File)new File(CommonUtils.folderLocal, "ftbutilities/all_permissions_full_list.txt"), list);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        CMD_PERMISSION_NODES = new HashSet<String>();
    }
}

