/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util;

import com.feed_the_beast.ftbl.api.FTBLibAPI;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBUtilitiesAPI;
import com.feed_the_beast.ftbu.util.FTBUPlayerData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class Badges {
    public static final String MAIN_ADDRESS = "badges.latmod.com";
    public static final int MAIN_PORT = 25566;
    private static final String FALLBACK_URL = "http://badges.latmod.com/get?id=";
    public static final Map<UUID, String> BADGE_CACHE = new HashMap<UUID, String>();
    public static final Map<UUID, String> LOCAL_BADGES = new HashMap<UUID, String>();

    public static void update(UUID playerId) {
        BADGE_CACHE.remove(playerId);
    }

    public static String get(UUID playerId) {
        String badge = BADGE_CACHE.get(playerId);
        if (badge != null) {
            return badge;
        }
        badge = Badges.getRaw(playerId);
        BADGE_CACHE.put(playerId, badge);
        return badge;
    }

    private static String getRaw(UUID playerId) {
        String badge;
        IForgePlayer player = FTBLibAPI.API.getUniverse().getPlayer(playerId);
        if (player == null || player.isFake()) {
            return "";
        }
        FTBUPlayerData data = FTBUPlayerData.get(player);
        if (!data.renderBadge.getBoolean()) {
            return "";
        }
        if (FTBUConfig.login.enable_global_badges && !data.disableGlobalBadge.getBoolean()) {
            Socket socket = null;
            DataOutputStream output = null;
            DataInputStream input = null;
            try {
                socket = new Socket(MAIN_ADDRESS, 25566);
                output = new DataOutputStream(socket.getOutputStream());
                output.writeLong(playerId.getMostSignificantBits());
                output.writeLong(playerId.getLeastSignificantBits());
                output.flush();
                input = new DataInputStream(socket.getInputStream());
                String badge2 = input.readUTF();
                boolean event = input.readBoolean();
                if (!(badge2.isEmpty() || !FTBUConfig.login.enable_event_badges && event)) {
                    return badge2;
                }
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly((OutputStream)output);
                IOUtils.closeQuietly((Socket)socket);
            }
            catch (Exception ex) {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
                IOUtils.closeQuietly((Socket)socket);
                FTBUFinals.LOGGER.warn("Main Badge API errored, using fallback: " + ex);
                try {
                    HttpURLConnection connection = (HttpURLConnection)new URL(FALLBACK_URL + StringUtils.fromUUID((UUID)playerId)).openConnection();
                    String badge3 = StringUtils.readString((InputStream)connection.getInputStream());
                    if (!badge3.isEmpty()) {
                        return badge3;
                    }
                }
                catch (Exception ex2) {
                    FTBUFinals.LOGGER.warn("Fallback Badge API errored: " + ex2);
                }
            }
        }
        return (badge = LOCAL_BADGES.get(playerId)) == null || badge.isEmpty() ? FTBUtilitiesAPI.API.getRankConfig(player.getProfile(), "ftbu.badge").getString() : badge;
    }

    public static boolean reloadServerBadges() {
        try {
            BADGE_CACHE.clear();
            LOCAL_BADGES.clear();
            File file = new File(CommonUtils.folderLocal, "ftbutilities/server_badges.json");
            if (!file.exists()) {
                JsonObject o = new JsonObject();
                o.addProperty("uuid", "url_to.png");
                o.addProperty("username", "url2_to.png");
                JsonUtils.toJson((JsonElement)o, (File)file);
            } else {
                for (Map.Entry entry : JsonUtils.fromJson((File)file).getAsJsonObject().entrySet()) {
                    IForgePlayer player = FTBLibAPI.API.getUniverse().getPlayer((CharSequence)entry.getKey());
                    if (player == null) continue;
                    LOCAL_BADGES.put(player.getId(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

