/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util;

import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.player.ForgePlayerConfigEvent;
import com.feed_the_beast.ftbl.lib.config.ConfigBoolean;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.math.BlockDimPos;
import com.feed_the_beast.ftbu.handlers.FTBLibIntegration;
import com.feed_the_beast.ftbu.util.BlockDimPosStorage;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUPlayerData
implements INBTSerializable<NBTTagCompound> {
    public final ConfigBoolean renderBadge = new ConfigBoolean(true);
    public final ConfigBoolean disableGlobalBadge = new ConfigBoolean(false);
    public final ConfigBoolean enablePVP = new ConfigBoolean(true);
    public final IForgePlayer player;
    public BlockDimPos lastDeath;
    public BlockDimPos lastSafePos;
    public IForgeTeam lastChunkTeam;
    public final BlockDimPosStorage homes;
    public boolean fly;

    public FTBUPlayerData(IForgePlayer p) {
        this.player = p;
        this.homes = new BlockDimPosStorage();
    }

    public static FTBUPlayerData get(IForgePlayer player) {
        return (FTBUPlayerData)player.getData().get(FTBLibIntegration.FTBU_DATA);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound homesTag;
        NBTTagCompound nbt = new NBTTagCompound();
        if (!this.renderBadge.getBoolean()) {
            nbt.func_74757_a("RenderBadge", false);
        }
        if (this.disableGlobalBadge.getBoolean()) {
            nbt.func_74757_a("DisableGlobalBadges", true);
        }
        if (!this.enablePVP.getBoolean()) {
            nbt.func_74757_a("EnablePVP", false);
        }
        if (!(homesTag = this.homes.serializeNBT()).func_82582_d()) {
            nbt.func_74782_a("Homes", (NBTBase)homesTag);
        }
        if (this.fly) {
            nbt.func_74757_a("AllowFlying", true);
        }
        if (this.lastDeath != null) {
            nbt.func_74783_a("LastDeath", this.lastDeath.toIntArray());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        this.renderBadge.setBoolean(!nbt.func_74764_b("RenderBadge") || nbt.func_74767_n("RenderBadge"));
        this.disableGlobalBadge.setBoolean(nbt.func_74767_n("DisableGlobalBadges"));
        this.enablePVP.setBoolean(!nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP"));
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.fly = nbt.func_74767_n("AllowFlying");
        this.lastDeath = null;
        if (nbt.func_74764_b("LastDeath")) {
            int[] ai = nbt.func_74759_k("LastDeath");
            this.lastDeath = ai.length == 4 ? new BlockDimPos(ai) : null;
        }
    }

    public void addConfig(ForgePlayerConfigEvent event) {
        String group = "ftbu";
        event.getConfig().setGroupName(group, (ITextComponent)new TextComponentString("FTBUtilities"));
        event.getConfig().add(group, "render_badge", (ConfigValue)this.renderBadge);
        event.getConfig().add(group, "disable_global_badge", (ConfigValue)this.disableGlobalBadge);
        event.getConfig().add(group, "enable_pvp", (ConfigValue)this.enablePVP);
    }
}

