/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.team.ForgeTeamConfigEvent;
import com.feed_the_beast.ftbl.lib.config.ConfigBoolean;
import com.feed_the_beast.ftbl.lib.config.ConfigEnum;
import com.feed_the_beast.ftbl.lib.config.ConfigValue;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbu.api.FTBUtilitiesAPI;
import com.feed_the_beast.ftbu.api.chunks.BlockInteractionType;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunk;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.handlers.FTBLibIntegration;
import com.feed_the_beast.ftbu.util.FTBUUniverseData;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.util.INBTSerializable;

public class FTBUTeamData
implements INBTSerializable<NBTTagCompound> {
    public final IForgeTeam team;
    private final ConfigEnum<EnumTeamStatus> editBlocks = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigEnum<EnumTeamStatus> interactWithBlocks = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    private final ConfigEnum<EnumTeamStatus> attackEntities = new ConfigEnum(EnumTeamStatus.NAME_MAP_PERMS);
    public final ConfigBoolean explosions = new ConfigBoolean(false);
    public boolean canForceChunks = false;

    public static FTBUTeamData get(IForgeTeam team) {
        return (FTBUTeamData)team.getData().get(FTBLibIntegration.FTBU_DATA);
    }

    public FTBUTeamData(IForgeTeam t) {
        this.team = t;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.explosions.getBoolean()) {
            nbt.func_74757_a("Explosions", this.explosions.getBoolean());
        }
        nbt.func_74778_a("EditBlocks", this.editBlocks.getString());
        if (this.interactWithBlocks.getBoolean()) {
            nbt.func_74778_a("InteractWithBlocks", this.interactWithBlocks.getString());
        }
        if (this.attackEntities.getBoolean()) {
            nbt.func_74778_a("AttackEntities", this.attackEntities.getString());
        }
        Int2ObjectOpenHashMap claimedChunks = new Int2ObjectOpenHashMap();
        for (ClaimedChunk chunk : ClaimedChunks.INSTANCE.getTeamChunks(this.team)) {
            ChunkDimPos pos = chunk.getPos();
            NBTTagList list = (NBTTagList)claimedChunks.get(pos.dim);
            if (list == null) {
                list = new NBTTagList();
                claimedChunks.put(pos.dim, (Object)list);
            }
            NBTTagCompound chunkNBT = new NBTTagCompound();
            chunkNBT.func_74768_a("x", pos.posX);
            chunkNBT.func_74768_a("z", pos.posZ);
            for (ChunkUpgrade upgrade : FTBUUniverseData.CHUNK_UPGRADES.values()) {
                if (upgrade.isInternal() || !chunk.hasUpgrade(upgrade)) continue;
                chunkNBT.func_74757_a(upgrade.func_176610_l(), true);
            }
            list.func_74742_a((NBTBase)chunkNBT);
        }
        NBTTagCompound claimedChunksTag = new NBTTagCompound();
        for (Map.Entry entry : claimedChunks.entrySet()) {
            claimedChunksTag.func_74782_a(((Integer)entry.getKey()).toString(), (NBTBase)entry.getValue());
        }
        if (!claimedChunksTag.func_82582_d()) {
            nbt.func_74782_a("ClaimedChunks", (NBTBase)claimedChunksTag);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.explosions.setBoolean(nbt.func_74767_n("Explosions"));
        this.editBlocks.setValueFromString(nbt.func_74779_i("EditBlocks"), false);
        this.interactWithBlocks.setValueFromString(nbt.func_74779_i("InteractWithBlocks"), false);
        this.attackEntities.setValueFromString(nbt.func_74779_i("AttackEntities"), false);
        NBTTagCompound claimedChunksTag = nbt.func_74775_l("ClaimedChunks");
        for (String dim : claimedChunksTag.func_150296_c()) {
            NBTTagList list = claimedChunksTag.func_150295_c(dim, 10);
            int dimInt = Integer.parseInt(dim);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound chunkNBT = list.func_150305_b(i);
                ClaimedChunk chunk = new ClaimedChunk(new ChunkDimPos(new ChunkPos(chunkNBT.func_74762_e("x"), chunkNBT.func_74762_e("z")), dimInt), this);
                for (ChunkUpgrade upgrade : FTBUUniverseData.CHUNK_UPGRADES.values()) {
                    if (upgrade.isInternal() || !chunkNBT.func_74767_n(upgrade.func_176610_l())) continue;
                    chunk.setHasUpgrade(upgrade, true);
                }
                ClaimedChunks.INSTANCE.addChunk(chunk);
            }
        }
    }

    public EnumTeamStatus getStatusFromType(BlockInteractionType type) {
        if (type == BlockInteractionType.INTERACT) {
            return (EnumTeamStatus)this.interactWithBlocks.getValue();
        }
        return (EnumTeamStatus)this.editBlocks.getValue();
    }

    public EnumTeamStatus getAttackEntitiesStatus() {
        return (EnumTeamStatus)this.attackEntities.getValue();
    }

    public void addConfig(ForgeTeamConfigEvent event) {
        String group = "ftbu";
        event.getConfig().setGroupName(group, (ITextComponent)new TextComponentString("FTBUtilities"));
        event.getConfig().add(group, "explosions", (ConfigValue)this.explosions);
        event.getConfig().add(group, "blocks_edit", this.editBlocks);
        event.getConfig().add(group, "blocks_interact", this.interactWithBlocks);
        event.getConfig().add(group, "attack_entities", this.attackEntities);
    }

    public int getMaxClaimChunks() {
        int p = 0;
        for (IForgePlayer player : this.team.getMembers()) {
            p += FTBUtilitiesAPI.API.getRankConfig(player.getProfile(), "ftbu.claims.max_chunks").getInt();
        }
        return p;
    }

    public int getMaxChunkloaderChunks() {
        int p = 0;
        for (IForgePlayer player : this.team.getMembers()) {
            p += FTBUtilitiesAPI.API.getRankConfig(player.getProfile(), "ftbu.chunkloader.max_chunks").getInt();
        }
        return p;
    }
}

