/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util;

import com.feed_the_beast.ftbl.api.EventHandler;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseClosedEvent;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseLoadedEvent;
import com.feed_the_beast.ftbl.api.universe.ForgeUniverseSavedEvent;
import com.feed_the_beast.ftbl.lib.math.ChunkDimPos;
import com.feed_the_beast.ftbl.lib.math.MathUtils;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.StringUtils;
import com.feed_the_beast.ftbl.lib.util.misc.ChatHistory;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.api.chunks.ChunkUpgrade;
import com.feed_the_beast.ftbu.api_impl.ClaimedChunks;
import com.feed_the_beast.ftbu.handlers.FTBLibIntegration;
import com.feed_the_beast.ftbu.util.Badges;
import com.feed_the_beast.ftbu.util.BlockDimPosStorage;
import com.feed_the_beast.ftbu.util.backups.Backups;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@EventHandler
public class FTBUUniverseData {
    public static long shutdownTime;
    public static final BlockDimPosStorage WARPS;
    public static final ChatHistory GENERAL_CHAT;
    public static final Map<String, ChunkUpgrade> CHUNK_UPGRADES;

    public static boolean isInSpawn(ChunkDimPos pos) {
        MinecraftServer server = ServerUtils.getServer();
        if (pos.dim != 0 || !server.func_71262_S() && !FTBUConfig.world.spawn_area_in_sp) {
            return false;
        }
        int radius = server.func_82357_ak();
        if (radius <= 0) {
            return false;
        }
        BlockPos c = server.func_130014_f_().func_175694_M();
        int minX = MathUtils.chunk((int)(c.func_177958_n() - radius));
        int minZ = MathUtils.chunk((int)(c.func_177952_p() - radius));
        int maxX = MathUtils.chunk((int)(c.func_177958_n() + radius));
        int maxZ = MathUtils.chunk((int)(c.func_177952_p() + radius));
        return pos.posX >= minX && pos.posX <= maxX && pos.posZ >= minZ && pos.posZ <= maxZ;
    }

    @SubscribeEvent
    public static void onUniversePostLoaded(ForgeUniverseLoadedEvent.Post event) {
        NBTTagCompound nbt = event.getData(FTBLibIntegration.FTBU_DATA);
        WARPS.deserializeNBT(nbt.func_74775_l("Warps"));
    }

    @SubscribeEvent
    public static void onUniverseLoaded(ForgeUniverseLoadedEvent.Finished event) {
        long start = event.getUniverse().getOverworld().func_82737_E();
        Backups.INSTANCE.nextBackup = start + FTBUConfig.backups.ticks();
        if (FTBUConfig.auto_shutdown.enabled && FTBUConfig.auto_shutdown.times.length > 0 && event.getUniverse().getServer().func_71262_S()) {
            Calendar calendar = Calendar.getInstance();
            int currentTime = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            int[] times = new int[FTBUConfig.auto_shutdown.times.length];
            for (int i = 0; i < times.length; ++i) {
                String[] s = FTBUConfig.auto_shutdown.times[i].split(":", 2);
                times[i] = Integer.parseInt(s[0]) * 3600 + Integer.parseInt(s[1]) * 60;
                if (times[i] > currentTime) continue;
                int n = i;
                times[n] = times[n] + 86400;
            }
            Arrays.sort(times);
            for (int time : times) {
                if (time <= currentTime) continue;
                shutdownTime = start + (long)(time - currentTime) * 20L;
                FTBUFinals.LOGGER.info(FTBULang.TIMER_SHUTDOWN.translate(new Object[]{StringUtils.getTimeStringTicks((long)shutdownTime)}));
                break;
            }
        }
        ClaimedChunks.INSTANCE.nextChunkloaderUpdate = start + 20L;
        Badges.LOCAL_BADGES.clear();
    }

    @SubscribeEvent
    public static void onUniverseSaved(ForgeUniverseSavedEvent event) {
        ClaimedChunks.INSTANCE.processQueue();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Warps", (NBTBase)WARPS.serializeNBT());
        event.setData(FTBLibIntegration.FTBU_DATA, nbt);
    }

    @SubscribeEvent
    public static void onUniverseClosed(ForgeUniverseClosedEvent event) {
        CHUNK_UPGRADES.clear();
        ClaimedChunks.INSTANCE.clear();
        Badges.BADGE_CACHE.clear();
        Badges.LOCAL_BADGES.clear();
    }

    static {
        WARPS = new BlockDimPosStorage();
        GENERAL_CHAT = new ChatHistory(() -> FTBUConfig.chat.general_history_limit);
        CHUNK_UPGRADES = new HashMap<String, ChunkUpgrade>();
    }
}

