/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.util.backups;

import com.feed_the_beast.ftbl.lib.util.CommonUtils;
import com.feed_the_beast.ftbl.lib.util.FileUtils;
import com.feed_the_beast.ftbl.lib.util.JsonUtils;
import com.feed_the_beast.ftbl.lib.util.LangKey;
import com.feed_the_beast.ftbl.lib.util.ServerUtils;
import com.feed_the_beast.ftbl.lib.util.text_components.Notification;
import com.feed_the_beast.ftbu.FTBUConfig;
import com.feed_the_beast.ftbu.FTBUFinals;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.util.backups.Backup;
import com.feed_the_beast.ftbu.util.backups.ThreadBackup;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Function;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldServer;

public enum Backups {
    INSTANCE;

    public static final ResourceLocation NOTIFICATION_ID;
    public final List<Backup> backups = new ArrayList<Backup>();
    public File backupsFolder;
    public long nextBackup = -1L;
    public ThreadBackup thread;

    public void init() {
        this.backupsFolder = FTBUConfig.backups.folder.isEmpty() ? new File(CommonUtils.folderMinecraft, "/backups/") : new File(FTBUConfig.backups.folder);
        this.thread = null;
        this.backups.clear();
        JsonElement element = JsonUtils.fromJson((File)new File(this.backupsFolder, "backups.json"));
        if (element.isJsonArray()) {
            try {
                for (JsonElement e : element.getAsJsonArray()) {
                    this.backups.add(new Backup(e.getAsJsonObject()));
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (this.backupsFolder.exists()) {
            String[] files = this.backupsFolder.list();
            int index = 0;
            if (files != null) {
                for (String s : files) {
                    String[] s1 = s.split("-");
                    if (s1.length < 6) continue;
                    int year = Integer.parseInt(s1[0]);
                    int month = Integer.parseInt(s1[1]);
                    int day = Integer.parseInt(s1[2]);
                    int hours = Integer.parseInt(s1[3]);
                    int minutes = Integer.parseInt(s1[4]);
                    int seconds = Integer.parseInt(s1[5].replace(".zip", ""));
                    Calendar c = Calendar.getInstance();
                    c.set(year, month, day, hours, minutes, seconds);
                    if (FTBUConfig.backups.compression_level > 0) {
                        s = s + ".zip";
                    }
                    this.backups.add(new Backup(c.getTimeInMillis(), s, ++index, true));
                }
            }
        }
        this.cleanupAndSave();
        FTBUFinals.LOGGER.info("Backups folder - " + this.backupsFolder.getAbsolutePath());
    }

    public static void notifyAll(Function<ICommandSender, ITextComponent> function, boolean error) {
        for (EntityPlayerMP player : ServerUtils.getPlayers()) {
            ITextComponent component = function.apply((ICommandSender)player);
            component.func_150256_b().func_150238_a(error ? TextFormatting.DARK_RED : TextFormatting.LIGHT_PURPLE);
            Notification.of((ResourceLocation)NOTIFICATION_ID, (ITextComponent[])new ITextComponent[]{component}).setImportant(true).send(null);
        }
        FTBUFinals.LOGGER.info(function.apply(null).func_150260_c());
    }

    public boolean run(MinecraftServer server, ICommandSender sender, String customName) {
        boolean auto;
        if (this.thread != null) {
            return false;
        }
        boolean bl = auto = !(sender instanceof EntityPlayerMP);
        if (auto && !FTBUConfig.backups.enabled) {
            return false;
        }
        Backups.notifyAll(player -> FTBULang.BACKUP_START.textComponent(player, new Object[]{sender.func_70005_c_()}), false);
        this.nextBackup = CommonUtils.getWorldTime() + FTBUConfig.backups.ticks();
        try {
            if (server.func_184103_al() != null) {
                server.func_184103_al().func_72389_g();
            }
            try {
                for (int i = 0; i < server.field_71305_c.length; ++i) {
                    if (server.field_71305_c[i] == null) continue;
                    WorldServer worldserver = server.field_71305_c[i];
                    worldserver.field_73058_d = true;
                    worldserver.func_73044_a(true, null);
                }
            }
            catch (Exception ex1) {
                Backups.notifyAll(arg_0 -> ((LangKey)FTBULang.BACKUP_SAVING_FAILED).textComponent(arg_0), true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File wd = server.func_130014_f_().func_72860_G().func_75765_b();
        if (FTBUConfig.backups.use_separate_thread) {
            this.thread = new ThreadBackup(wd, customName);
            this.thread.start();
        } else {
            ThreadBackup.doBackup(wd, customName);
        }
        return true;
    }

    public void cleanupAndSave() {
        JsonArray a = new JsonArray();
        if (!this.backups.isEmpty()) {
            this.backups.sort(Backup.COMPARATOR);
            int backupsToKeep = FTBUConfig.backups.backups_to_keep;
            if (backupsToKeep > 0) {
                int toDelete;
                if (this.backups.size() > backupsToKeep && (toDelete = this.backups.size() - backupsToKeep) > 0) {
                    for (int i = toDelete - 1; i >= 0; --i) {
                        Backup b = this.backups.get(i);
                        FTBUFinals.LOGGER.info(FTBULang.BACKUP_DELETING_OLD.translate(new Object[]{b.fileId}));
                        FileUtils.delete((File)b.getFile());
                        this.backups.remove(i);
                    }
                }
                for (int i = this.backups.size() - 1; i >= 0; --i) {
                    if (this.backups.get(i).getFile().exists()) continue;
                    this.backups.remove(i);
                }
            }
            for (Backup t : this.backups) {
                a.add((JsonElement)t.toJsonObject());
            }
        }
        JsonUtils.toJson((JsonElement)a, (File)new File(this.backupsFolder, "backups.json"));
    }

    public void postBackup() {
        try {
            MinecraftServer server = ServerUtils.getServer();
            for (int i = 0; i < server.field_71305_c.length; ++i) {
                if (server.field_71305_c[i] == null) continue;
                WorldServer worldserver = server.field_71305_c[i];
                if (!worldserver.field_73058_d) continue;
                worldserver.field_73058_d = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    int getLastIndex() {
        int i = 0;
        for (Backup b : this.backups) {
            i = Math.max(i, b.index);
        }
        return i;
    }

    static {
        NOTIFICATION_ID = FTBUFinals.get("backup");
    }
}

